[coil-base](../../index.md) / [coil.transform](../index.md) / [BlurTransformation](./index.md)

# BlurTransformation

`class BlurTransformation : `[`Transformation`](../-transformation/index.md)

A [Transformation](../-transformation/index.md) that applies a Gaussian blur to an image.

### Parameters

`context` - The [Context](https://developer.android.com/reference/android/content/Context.html) used to create a [RenderScript](https://developer.android.com/reference/android/renderscript/RenderScript.html) instance.

`radius` - The radius of the blur.

`sampling` - The sampling multiplier used to scale the image. Values &gt; 1
will downscale the image. Values between 0 and 1 will upscale the image.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Transformation](../-transformation/index.md) that applies a Gaussian blur to an image.`BlurTransformation(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, radius: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)` = DEFAULT_RADIUS, sampling: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)` = DEFAULT_SAMPLING)` |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [key](key.md) | Return a unique key for this transformation.`fun key(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [transform](transform.md) | Apply the transformation to [input](../-transformation/transform.md#coil.transform.Transformation$transform(coil.bitmap.BitmapPool, android.graphics.Bitmap, coil.size.Size)/input).`suspend fun transform(pool: `[`BitmapPool`](../../coil.bitmap/-bitmap-pool/index.md)`, input: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`, size: `[`Size`](../../coil.size/-size.md)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html) |
