[coil-gif](../../index.md) / [coil.drawable](../index.md) / [ScaleDrawable](./index.md)

# ScaleDrawable

`class ScaleDrawable : `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, `[`Callback`](https://developer.android.com/reference/android/graphics/drawable/Drawable/Callback.html)`, `[`Animatable`](https://developer.android.com/reference/android/graphics/drawable/Animatable.html)

A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that centers and scales its [child](file:/Users/Colin/coil/docs/api/coil-base/coil.drawable/-scale-drawable/child.md) to fill its bounds.

This allows drawables that only draw within their intrinsic dimensions
(e.g. [AnimatedImageDrawable](https://developer.android.com/reference/android/graphics/drawable/AnimatedImageDrawable.html)) to fill their entire bounds.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that centers and scales its [child](file:/Users/Colin/coil/docs/api/coil-base/coil.drawable/-scale-drawable/child.md) to fill its bounds.`ScaleDrawable(child: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, scale: `[`Scale`](file:/Users/Colin/coil/docs/api/coil-base/coil.size/-scale/index.md)` = Scale.FIT)` |

### Properties

| Name | Summary |
|---|---|
| [child](child.md) | `val child: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) |

### Functions

| Name | Summary |
|---|---|
| [draw](draw.md) | `fun draw(canvas: `[`Canvas`](https://developer.android.com/reference/android/graphics/Canvas.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [getAlpha](get-alpha.md) | `fun getAlpha(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getColorFilter](get-color-filter.md) | `fun getColorFilter(): `[`ColorFilter`](https://developer.android.com/reference/android/graphics/ColorFilter.html)`?` |
| [getIntrinsicHeight](get-intrinsic-height.md) | `fun getIntrinsicHeight(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getIntrinsicWidth](get-intrinsic-width.md) | `fun getIntrinsicWidth(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getOpacity](get-opacity.md) | `fun getOpacity(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [invalidateDrawable](invalidate-drawable.md) | `fun invalidateDrawable(who: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [isRunning](is-running.md) | `fun isRunning(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onBoundsChange](on-bounds-change.md) | `fun onBoundsChange(bounds: `[`Rect`](https://developer.android.com/reference/android/graphics/Rect.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onLevelChange](on-level-change.md) | `fun onLevelChange(level: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onStateChange](on-state-change.md) | `fun onStateChange(state: `[`IntArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [scheduleDrawable](schedule-drawable.md) | `fun scheduleDrawable(who: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, what: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`, when: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setAlpha](set-alpha.md) | `fun setAlpha(alpha: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setColorFilter](set-color-filter.md) | `fun setColorFilter(colorFilter: `[`ColorFilter`](https://developer.android.com/reference/android/graphics/ColorFilter.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTint](set-tint.md) | `fun setTint(tintColor: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTintBlendMode](set-tint-blend-mode.md) | `fun setTintBlendMode(blendMode: `[`BlendMode`](https://developer.android.com/reference/android/graphics/BlendMode.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTintList](set-tint-list.md) | `fun setTintList(tint: `[`ColorStateList`](https://developer.android.com/reference/android/content/res/ColorStateList.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTintMode](set-tint-mode.md) | `fun setTintMode(tintMode: `[`Mode`](https://developer.android.com/reference/android/graphics/PorterDuff/Mode.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [start](start.md) | `fun start(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [stop](stop.md) | `fun stop(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [unscheduleDrawable](unschedule-drawable.md) | `fun unscheduleDrawable(who: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, what: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
