[coil-base](../../index.md) / [coil.decode](../index.md) / [DecodeUtils](./index.md)

# DecodeUtils

`object DecodeUtils`

A collection of useful utility methods for decoding images.

### Functions

| Name | Summary |
|---|---|
| [calculateInSampleSize](calculate-in-sample-size.md) | Calculate the [BitmapFactory.Options.inSampleSize](https://developer.android.com/reference/android/graphics/BitmapFactory/Options.html#inSampleSize) given the source dimensions of the image ([srcWidth](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/srcWidth) and [srcHeight](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/srcHeight)), the output dimensions ([destWidth](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/destWidth), [destHeight](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/destHeight)), and the [scale](calculate-in-sample-size.md#coil.decode.DecodeUtils$calculateInSampleSize(kotlin.Int, kotlin.Int, kotlin.Int, kotlin.Int, coil.size.Scale)/scale).`fun calculateInSampleSize(srcWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, srcHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, destWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, destHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [computeSizeMultiplier](compute-size-multiplier.md) | Calculate the percentage to multiply the source dimensions by to fit/fill the destination dimensions while preserving aspect ratio.`fun computeSizeMultiplier(srcWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, srcHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, destWidth: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, destHeight: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`fun computeSizeMultiplier(srcWidth: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, srcHeight: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, destWidth: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, destHeight: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)<br>`fun computeSizeMultiplier(srcWidth: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, srcHeight: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, destWidth: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, destHeight: `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`, scale: `[`Scale`](../../coil.size/-scale/index.md)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html) |
| [isAnimatedWebP](is-animated-web-p.md) | Return true if the [source](is-animated-web-p.md#coil.decode.DecodeUtils$isAnimatedWebP(okio.BufferedSource)/source) contains an animated WebP image. The [source](is-animated-web-p.md#coil.decode.DecodeUtils$isAnimatedWebP(okio.BufferedSource)/source) is not consumed.`fun isAnimatedWebP(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isGif](is-gif.md) | Return true if the [source](is-gif.md#coil.decode.DecodeUtils$isGif(okio.BufferedSource)/source) contains a GIF image. The [source](is-gif.md#coil.decode.DecodeUtils$isGif(okio.BufferedSource)/source) is not consumed.`fun isGif(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isWebP](is-web-p.md) | Return true if the [source](is-web-p.md#coil.decode.DecodeUtils$isWebP(okio.BufferedSource)/source) contains a WebP image. The [source](is-web-p.md#coil.decode.DecodeUtils$isWebP(okio.BufferedSource)/source) is not consumed.`fun isWebP(source: `[`BufferedSource`](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
