[coil-base](../../index.md) / [coil.request](../index.md) / [GetRequest](./index.md)

# GetRequest

`class GetRequest : `[`Request`](../-request/index.md)

A value object that represents a *get* image request.

Instances can be created and executed ad hoc:

```
val drawable = imageLoader.get("https://www.example.com/image.jpg") {
    size(1080, 1920)
}
```

Or instances can be created separately from the call that executes them:

```
val request = GetRequest(imageLoader.defaults) {
    data("https://www.example.com/image.jpg")
    size(1080, 1920)
}
imageLoader.get(request)
```

**See Also**

[GetRequestBuilder](../-get-request-builder/index.md)

[ImageLoader.get](../../coil/-image-loader/get.md)

### Properties

| Name | Summary |
|---|---|
| [aliasKeys](alias-keys.md) | `val aliasKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |
| [allowHardware](allow-hardware.md) | `val allowHardware: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [allowRgb565](allow-rgb565.md) | `val allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [bitmapConfig](bitmap-config.md) | `val bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html) |
| [colorSpace](color-space.md) | `val colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?` |
| [data](data.md) | `val data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html) |
| [decoder](decoder.md) | `val decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`?` |
| [diskCachePolicy](disk-cache-policy.md) | `val diskCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [dispatcher](dispatcher.md) | `val dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) |
| [error](error.md) | `val error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [fallback](fallback.md) | `val fallback: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [headers](headers.md) | `val headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) |
| [key](key.md) | `val key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [lifecycle](lifecycle.md) | `val lifecycle: `[`Lifecycle`](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle.html)`?` |
| [listener](listener.md) | `val listener: Listener?` |
| [memoryCachePolicy](memory-cache-policy.md) | `val memoryCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [networkCachePolicy](network-cache-policy.md) | `val networkCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [parameters](parameters.md) | `val parameters: `[`Parameters`](../-parameters/index.md) |
| [placeholder](placeholder.md) | `val placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [precision](precision.md) | `val precision: `[`Precision`](../../coil.size/-precision/index.md) |
| [scale](scale.md) | `val scale: `[`Scale`](../../coil.size/-scale/index.md)`?` |
| [sizeResolver](size-resolver.md) | `val sizeResolver: `[`SizeResolver`](../../coil.size/-size-resolver/index.md)`?` |
| [target](target.md) | `val target: `[`Target`](../../coil.target/-target/index.md)`?` |
| [transformations](transformations.md) | `val transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../coil.transform/-transformation/index.md)`>` |
| [transition](transition.md) | `val transition: `[`Transition`](../../coil.transition/-transition/index.md)`?` |

### Functions

| Name | Summary |
|---|---|
| [newBuilder](new-builder.md) | Create a new [GetRequestBuilder](../-get-request-builder/index.md) instance using this as a base.`fun newBuilder(): `[`GetRequestBuilder`](../-get-request-builder/index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a new [GetRequest](./index.md) instance.`operator fun invoke(defaults: `[`DefaultRequestOptions`](../../coil/-default-request-options/index.md)`, builder: `[`GetRequestBuilder`](../-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`GetRequest`](./index.md)<br>`operator fun invoke(request: `[`GetRequest`](./index.md)`, builder: `[`GetRequestBuilder`](../-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`GetRequest`](./index.md) |
