[coil-base](../../index.md) / [coil.request](../index.md) / [LoadRequestBuilder](./index.md)

# LoadRequestBuilder

`class LoadRequestBuilder : `[`RequestBuilder`](../-request-builder/index.md)`<`[`LoadRequestBuilder`](./index.md)`>`

Builder for a [LoadRequest](../-load-request/index.md).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `LoadRequestBuilder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, defaults: `[`DefaultRequestOptions`](../../coil/-default-request-options/index.md)`)`<br>`LoadRequestBuilder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, request: `[`LoadRequest`](../-load-request/index.md)`)` |

### Functions

| Name | Summary |
|---|---|
| [build](build.md) | Create a new [LoadRequest](../-load-request/index.md) instance.`fun build(): `[`LoadRequest`](../-load-request/index.md) |
| [crossfade](crossfade.md) | See: [ImageLoaderBuilder.crossfade](../../coil/-image-loader-builder/crossfade.md)`fun crossfade(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`LoadRequestBuilder`](./index.md)<br>`fun crossfade(durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`LoadRequestBuilder`](./index.md) |
| [data](data.md) | Set the data to load.`fun data(data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`LoadRequestBuilder`](./index.md) |
| [error](error.md) | Set the error drawable to use if the request fails.`fun error(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`LoadRequestBuilder`](./index.md)<br>`fun error(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`LoadRequestBuilder`](./index.md) |
| [fallback](fallback.md) | Set the fallback drawable to use if [data](data.md) is null.`fun fallback(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`LoadRequestBuilder`](./index.md)<br>`fun fallback(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`LoadRequestBuilder`](./index.md) |
| [lifecycle](lifecycle.md) | Set the [Lifecycle](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle.html) for this request.`fun lifecycle(owner: `[`LifecycleOwner`](https://developer.android.com/reference/androidx/androidx/lifecycle/LifecycleOwner.html)`?): `[`LoadRequestBuilder`](./index.md)<br>`fun lifecycle(lifecycle: `[`Lifecycle`](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle.html)`?): `[`LoadRequestBuilder`](./index.md) |
| [placeholder](placeholder.md) | Set the placeholder drawable to use when the request starts.`fun placeholder(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`LoadRequestBuilder`](./index.md)<br>`fun placeholder(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`LoadRequestBuilder`](./index.md) |
| [target](target.md) | Convenience function to set [imageView](target.md#coil.request.LoadRequestBuilder$target(android.widget.ImageView)/imageView) as the [Target](../../coil.target/-target/index.md).`fun target(imageView: `[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`): `[`LoadRequestBuilder`](./index.md)<br>Convenience function to create and set the [Target](../../coil.target/-target/index.md).`fun target(onStart: (placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onError: (error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onSuccess: (result: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`LoadRequestBuilder`](./index.md)<br>Set the [Target](../../coil.target/-target/index.md). If the target is null, this request will preload the image into memory.`fun target(target: `[`Target`](../../coil.target/-target/index.md)`?): `[`LoadRequestBuilder`](./index.md) |
| [transition](transition.md) | See: [ImageLoaderBuilder.transition](../../coil/-image-loader-builder/transition.md)`fun transition(transition: `[`Transition`](../../coil.transition/-transition/index.md)`?): `[`LoadRequestBuilder`](./index.md) |
