[coil-base](../../index.md) / [coil.request](../index.md) / [Parameters](./index.md)

# Parameters

`class Parameters : `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>`

A map of generic values that can be used to pass custom data to [Fetcher](../../coil.fetch/-fetcher/index.md)s and [Decoder](../../coil.decode/-decoder/index.md)s.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |
| [Entry](-entry/index.md) | `data class Entry` |

### Functions

| Name | Summary |
|---|---|
| [cacheKey](cache-key.md) | Returns the cache key associated with [key](cache-key.md#coil.request.Parameters$cacheKey(kotlin.String)/key) or null if [key](cache-key.md#coil.request.Parameters$cacheKey(kotlin.String)/key) has no mapping.`fun cacheKey(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [count](count.md) | Returns the number of parameters in this object.`fun count(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [entry](entry.md) | Returns the entry associated with [key](entry.md#coil.request.Parameters$entry(kotlin.String)/key) or null if [key](entry.md#coil.request.Parameters$entry(kotlin.String)/key) has no mapping.`fun entry(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): Entry?` |
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [isEmpty](is-empty.md) | Returns true if this object has no parameters.`fun isEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [iterator](iterator.md) | Returns an [Iterator](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html) over the entries in the [Parameters](./index.md). Iteration order is deterministic.`operator fun iterator(): `[`Iterator`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>` |
| [newBuilder](new-builder.md) | `fun newBuilder(): Builder` |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [value](value.md) | Returns the value associated with [key](value.md#coil.request.Parameters$value(kotlin.String)/key) or null if [key](value.md#coil.request.Parameters$value(kotlin.String)/key) has no mapping.`fun value(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |

### Companion Object Properties

| Name | Summary |
|---|---|
| [EMPTY](-e-m-p-t-y.md) | `val EMPTY: `[`Parameters`](./index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a new [Parameters](./index.md) instance.`operator fun invoke(builder: Builder.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Parameters`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [get](../../coil.extension/get.md) | `operator fun `[`Parameters`](./index.md)`.get(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [isNotEmpty](../../coil.extension/is-not-empty.md) | `fun `[`Parameters`](./index.md)`.isNotEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
