[coil-base](../index.md) / [coil.request](./index.md)

## Package coil.request

### Types

| Name | Summary |
|---|---|
| [CachePolicy](-cache-policy/index.md) | Represents the read/write policy for a cache source.`enum class CachePolicy` |
| [GetRequest](-get-request/index.md) | A value object that represents a *get* image request.`class GetRequest : `[`Request`](-request/index.md) |
| [GetRequestBuilder](-get-request-builder/index.md) | Builder for a [GetRequest](-get-request/index.md).`class GetRequestBuilder : `[`RequestBuilder`](-request-builder/index.md)`<`[`GetRequestBuilder`](-get-request-builder/index.md)`>` |
| [LoadRequest](-load-request/index.md) | A value object that represents a *load* image request.`class LoadRequest : `[`Request`](-request/index.md) |
| [LoadRequestBuilder](-load-request-builder/index.md) | Builder for a [LoadRequest](-load-request/index.md).`class LoadRequestBuilder : `[`RequestBuilder`](-request-builder/index.md)`<`[`LoadRequestBuilder`](-load-request-builder/index.md)`>` |
| [Parameters](-parameters/index.md) | A map of generic values that can be used to pass custom data to [Fetcher](../coil.fetch/-fetcher/index.md)s and [Decoder](../coil.decode/-decoder/index.md)s.`class Parameters : `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, Entry>>` |
| [Request](-request/index.md) | A value object that represents an image request.`sealed class Request` |
| [RequestBuilder](-request-builder/index.md) | Base class for [LoadRequestBuilder](-load-request-builder/index.md) and [GetRequestBuilder](-get-request-builder/index.md).`sealed class RequestBuilder<T : `[`RequestBuilder`](-request-builder/index.md)`<T>>` |
| [RequestDisposable](-request-disposable/index.md) | Represents the work of an [ImageLoader.load](../coil/-image-loader/load.md) request.`interface RequestDisposable` |

### Exceptions

| Name | Summary |
|---|---|
| [NullRequestDataException](-null-request-data-exception/index.md) | Exception for when null [Request.data](-request/data.md) is passed to [ImageLoader.load](../coil/-image-loader/load.md).`class NullRequestDataException : `[`RuntimeException`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |
