[coil-base](../../index.md) / [coil.target](../index.md) / [Target](./index.md)

# Target

`interface Target`

A listener that accepts the result of an image load.

Each lifecycle method is called at most once. [onSuccess](on-success.md) and [onError](on-error.md) are mutually exclusive.

### Functions

| Name | Summary |
|---|---|
| [onError](on-error.md) | Called if the image request fails.`open fun onError(error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onStart](on-start.md) | Called when the image request starts.`open fun onStart(placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSuccess](on-success.md) | Called if the image request is successful.`open fun onSuccess(result: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [ViewTarget](../-view-target/index.md) | A [Target](./index.md) with an associated [View](https://developer.android.com/reference/android/view/View.html).`interface ViewTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`Target`](./index.md) |
