[coil-base](../../index.md) / [coil.target](../index.md) / [ViewTarget](./index.md)

# ViewTarget

`interface ViewTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`Target`](../-target/index.md)

A [Target](../-target/index.md) with an associated [View](https://developer.android.com/reference/android/view/View.html).

If the loaded [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) will only be used with one [View](https://developer.android.com/reference/android/view/View.html), prefer this to [Target](../-target/index.md).

Unlike [Target](../-target/index.md)s, [ViewTarget](./index.md)s can have their lifecycle methods called multiple times.

Optionally, a [ViewTarget](./index.md) can be declared as a [LifecycleObserver](https://developer.android.com/reference/androidx/androidx/lifecycle/LifecycleObserver.html). It is automatically registered when the request
starts and unregistered when the request is disposed.

### Properties

| Name | Summary |
|---|---|
| [view](view.md) | The [View](https://developer.android.com/reference/android/view/View.html) used by this [Target](../-target/index.md).`abstract val view: T` |

### Inheritors

| Name | Summary |
|---|---|
| [PoolableViewTarget](../-poolable-view-target/index.md) | A [ViewTarget](./index.md) that supports [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) pooling.`interface PoolableViewTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`ViewTarget`](./index.md)`<T>` |
| [TransitionTarget](../../coil.transition/-transition-target/index.md) | A [Target](../-target/index.md) that supports applying [Transition](../../coil.transition/-transition/index.md)s.`interface TransitionTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`ViewTarget`](./index.md)`<T>` |
