[coil-base](../../index.md) / [coil.transform](../index.md) / [RoundedCornersTransformation](index.md) / [transform](./transform.md)

# transform

`suspend fun transform(pool: `[`BitmapPool`](../../coil.bitmappool/-bitmap-pool/index.md)`, input: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`, size: `[`Size`](../../coil.size/-size.md)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)

Apply the transformation to [input](../-transformation/transform.md#coil.transform.Transformation$transform(coil.bitmappool.BitmapPool, android.graphics.Bitmap, coil.size.Size)/input).

For optimal performance, do not use [Bitmap.createBitmap](https://developer.android.com/reference/android/graphics/Bitmap.html#createBitmap(android.graphics.Bitmap)) inside this method. Instead, use the provided
[BitmapPool](../../coil.bitmappool/-bitmap-pool/index.md) to get new [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s. Also, you should return every bitmap except the output bitmap to [pool](../-transformation/transform.md#coil.transform.Transformation$transform(coil.bitmappool.BitmapPool, android.graphics.Bitmap, coil.size.Size)/pool)
so that they can be reused.

### Parameters

`pool` - A [BitmapPool](../../coil.bitmappool/-bitmap-pool/index.md) which can be used to request [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) instances.

`input` - The input [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) to transform. Its config will always be one of [VALID_CONFIGS](#).

`size` - The size of the image request.

**See Also**

[BitmapPool.get](../../coil.bitmappool/-bitmap-pool/get.md)

[BitmapPool.put](../../coil.bitmappool/-bitmap-pool/put.md)

