[coil-base](../../index.md) / [coil](../index.md) / [ImageLoader](./index.md)

# ImageLoader

`interface ImageLoader`

Loads images using [load](load.md) and [get](get.md).

### Properties

| Name | Summary |
|---|---|
| [defaults](defaults.md) | The default options for any [Request](../../coil.request/-request/index.md)s created by this image loader.`abstract val defaults: `[`DefaultRequestOptions`](../-default-request-options/index.md) |

### Functions

| Name | Summary |
|---|---|
| [clearMemory](clear-memory.md) | Completely clear this image loader's memory cache and bitmap pool.`abstract fun clearMemory(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [get](get.md) | Load the [request](get.md#coil.ImageLoader$get(coil.request.GetRequest)/request)'s data and suspend until the operation is complete. Return the loaded [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).`abstract suspend fun get(request: `[`GetRequest`](../../coil.request/-get-request/index.md)`): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) |
| [load](load.md) | Start an asynchronous operation to load the [request](load.md#coil.ImageLoader$load(coil.request.LoadRequest)/request)'s data into its [Target](../../coil.target/-target/index.md).`abstract fun load(request: `[`LoadRequest`](../../coil.request/-load-request/index.md)`): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md) |
| [shutdown](shutdown.md) | Shutdown this image loader.`abstract fun shutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a new [ImageLoader](./index.md) instance.`operator fun invoke(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, builder: `[`ImageLoaderBuilder`](../-image-loader-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`ImageLoader`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [get](../../coil.api/get.md) | `suspend fun `[`ImageLoader`](./index.md)`.get(uri: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)<br>`suspend fun `[`ImageLoader`](./index.md)`.get(url: `[`HttpUrl`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/HttpUrl.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)<br>`suspend fun `[`ImageLoader`](./index.md)`.get(uri: `[`Uri`](https://developer.android.com/reference/android/net/Uri.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)<br>`suspend fun `[`ImageLoader`](./index.md)`.get(file: `[`File`](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)<br>`suspend fun `[`ImageLoader`](./index.md)`.get(drawableRes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)<br>`suspend fun `[`ImageLoader`](./index.md)`.get(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)<br>`suspend fun `[`ImageLoader`](./index.md)`.get(bitmap: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) |
| [getAny](../../coil.api/get-any.md) | `suspend fun `[`ImageLoader`](./index.md)`.getAny(data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, builder: `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) |
| [load](../../coil.api/load.md) | `fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, uri: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>`fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, url: `[`HttpUrl`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/HttpUrl.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>`fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, uri: `[`Uri`](https://developer.android.com/reference/android/net/Uri.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>`fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, file: `[`File`](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>`fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, drawableRes: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>`fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md)<br>`fun `[`ImageLoader`](./index.md)`.load(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, bitmap: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md) |
| [loadAny](../../coil.api/load-any.md) | `fun `[`ImageLoader`](./index.md)`.loadAny(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, builder: `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): `[`RequestDisposable`](../../coil.request/-request-disposable/index.md) |
| [newGetBuilder](../../coil.api/new-get-builder.md) | `fun `[`ImageLoader`](./index.md)`.newGetBuilder(): `[`GetRequestBuilder`](../../coil.request/-get-request-builder/index.md) |
| [newLoadBuilder](../../coil.api/new-load-builder.md) | `fun `[`ImageLoader`](./index.md)`.newLoadBuilder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`): `[`LoadRequestBuilder`](../../coil.request/-load-request-builder/index.md) |
