[coil-base](../../index.md) / [coil.decode](../index.md) / [Options](./index.md)

# Options

`data class Options`

A set of configuration options for fetching and decoding an image.

[Fetcher](../../coil.fetch/-fetcher/index.md)s and [Decoder](../-decoder/index.md)s should respect these options as best as possible.

### Parameters

`config` - The requested config for any [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s.

`colorSpace` - The preferred color space for any [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s.
If null, components should typically default to [ColorSpace.Rgb](https://developer.android.com/reference/android/graphics/ColorSpace/Rgb.html).

`scale` - The scaling algorithm for how to fit the source image's dimensions into the target's dimensions.

`allowInexactSize` - True if the output image does not need to fit/fill the target's dimensions exactly. For instance,
if true [BitmapFactoryDecoder](#) will not decode an image at a larger size than its source dimensions as an optimization.

`allowRgb565` - True if a component is allowed to use [Bitmap.Config.RGB_565](https://developer.android.com/reference/android/graphics/Bitmap/Config.html#RGB_565) as an optimization. As RGB_565 does
not have an alpha channel, components should only use RGB_565 if the image is guaranteed to not use alpha.

`headers` - The header fields to use for any network requests.

`parameters` - A map of custom parameters. These are used to pass custom data to a component.

`networkCachePolicy` - Determines if this request is allowed to read from the network.

`diskCachePolicy` - Determines if this request is allowed to read/write from/to disk.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A set of configuration options for fetching and decoding an image.`Options(config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`, colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?, scale: `[`Scale`](../../coil.size/-scale/index.md)`, allowInexactSize: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html)`, parameters: `[`Parameters`](../../coil.request/-parameters/index.md)`, networkCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)`, diskCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)`)` |

### Properties

| Name | Summary |
|---|---|
| [allowInexactSize](allow-inexact-size.md) | True if the output image does not need to fit/fill the target's dimensions exactly. For instance, if true [BitmapFactoryDecoder](#) will not decode an image at a larger size than its source dimensions as an optimization.`val allowInexactSize: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [allowRgb565](allow-rgb565.md) | True if a component is allowed to use [Bitmap.Config.RGB_565](https://developer.android.com/reference/android/graphics/Bitmap/Config.html#RGB_565) as an optimization. As RGB_565 does not have an alpha channel, components should only use RGB_565 if the image is guaranteed to not use alpha.`val allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [colorSpace](color-space.md) | The preferred color space for any [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s. If null, components should typically default to [ColorSpace.Rgb](https://developer.android.com/reference/android/graphics/ColorSpace/Rgb.html).`val colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?` |
| [config](config.md) | The requested config for any [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s.`val config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html) |
| [diskCachePolicy](disk-cache-policy.md) | Determines if this request is allowed to read/write from/to disk.`val diskCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md) |
| [headers](headers.md) | The header fields to use for any network requests.`val headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) |
| [networkCachePolicy](network-cache-policy.md) | Determines if this request is allowed to read from the network.`val networkCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md) |
| [parameters](parameters.md) | A map of custom parameters. These are used to pass custom data to a component.`val parameters: `[`Parameters`](../../coil.request/-parameters/index.md) |
| [scale](scale.md) | The scaling algorithm for how to fit the source image's dimensions into the target's dimensions.`val scale: `[`Scale`](../../coil.size/-scale/index.md) |
