[coil-base](../../index.md) / [coil.transform](../index.md) / [Transformation](./index.md)

# Transformation

`interface Transformation`

An interface for making transformations to an image's pixel data.

NOTE: If [DrawableResult.drawable](../../coil.fetch/-drawable-result/drawable.md) or [DecodeResult.drawable](../../coil.decode/-decode-result/drawable.md) is not a [BitmapDrawable](https://developer.android.com/reference/android/graphics/drawable/BitmapDrawable.html), it will be converted to one.
This will cause animated drawables to only draw the first frame of their animation.

**See Also**

[RequestBuilder.transformations](../../coil.request/-request-builder/transformations.md)

### Functions

| Name | Summary |
|---|---|
| [key](key.md) | Return a unique key for this transformation.`abstract fun key(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [transform](transform.md) | Apply the transformation to [input](transform.md#coil.transform.Transformation$transform(coil.bitmappool.BitmapPool, android.graphics.Bitmap, coil.size.Size)/input).`abstract suspend fun transform(pool: `[`BitmapPool`](../../coil.bitmappool/-bitmap-pool/index.md)`, input: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`, size: `[`Size`](../../coil.size/-size.md)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html) |

### Inheritors

| Name | Summary |
|---|---|
| [BlurTransformation](../-blur-transformation/index.md) | A [Transformation](./index.md) that applies a Gaussian blur to an image.`class BlurTransformation : `[`Transformation`](./index.md) |
| [CircleCropTransformation](../-circle-crop-transformation/index.md) | A [Transformation](./index.md) that crops an image using a centered circle as the mask.`class CircleCropTransformation : `[`Transformation`](./index.md) |
| [GrayscaleTransformation](../-grayscale-transformation/index.md) | A [Transformation](./index.md) that converts an image to shades of gray.`class GrayscaleTransformation : `[`Transformation`](./index.md) |
| [RoundedCornersTransformation](../-rounded-corners-transformation/index.md) | A [Transformation](./index.md) that crops the image to fit the target's dimensions and rounds the corners of the image.`class RoundedCornersTransformation : `[`Transformation`](./index.md) |
