

### All Types

| Name | Summary |
|---|---|
|

##### [coil.bitmappool.BitmapPool](../coil.bitmappool/-bitmap-pool/index.md)

An object pool that enables callers to reuse [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) objects.


|

##### [coil.transform.BlurTransformation](../coil.transform/-blur-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that applies a Gaussian blur to an image.


|

##### [coil.annotation.BuilderMarker](../coil.annotation/-builder-marker/index.md)

Marks builder classes that are part of a DSL.
This restricts calling an outer scope if it is also marked by [DslMarker](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-dsl-marker/index.html).


|

##### [coil.request.CachePolicy](../coil.request/-cache-policy/index.md)

Represents the read/write policy for a cache source.


|

##### [coil.transform.CircleCropTransformation](../coil.transform/-circle-crop-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that crops an image using a centered circle as the mask.


|

##### [coil.util.CoilLogger](../coil.util/-coil-logger/index.md)

A singleton that enables/disables logging to [Log](https://developer.android.com/reference/android/util/Log.html).


|

##### [coil.util.CoilUtils](../coil.util/-coil-utils/index.md)

Public utility methods for Coil.


|

##### [coil.ComponentRegistry](../coil/-component-registry/index.md)

Registry for all the components that an [ImageLoader](../coil/-image-loader/index.md) uses to fulfil image requests.


|

##### [coil.drawable.CrossfadeDrawable](../coil.drawable/-crossfade-drawable/index.md)

A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that crossfades from [start](../coil.drawable/-crossfade-drawable/start.md) to [end](../coil.drawable/-crossfade-drawable/end.md).


|

##### [coil.transition.CrossfadeTransition](../coil.transition/-crossfade-transition/index.md)

A [Transition](../coil.transition/-transition/index.md) that crossfades from the current drawable to a new one.


|

##### [coil.decode.DataSource](../coil.decode/-data-source/index.md)

Represents the source that a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) was loaded from.


|

##### [coil.decode.Decoder](../coil.decode/-decoder/index.md)

Converts a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) into a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).


|

##### [coil.decode.DecodeResult](../coil.decode/-decode-result/index.md)

The result of [Decoder.decode](../coil.decode/-decoder/decode.md).


|

##### [coil.decode.DecodeUtils](../coil.decode/-decode-utils/index.md)

A collection of useful utility methods for decoding images.


|

##### [coil.DefaultRequestOptions](../coil/-default-request-options/index.md)

A set of default request options, which are used to initialize a [RequestBuilder](../coil.request/-request-builder/index.md).


|

##### [coil.size.DisplaySizeResolver](../coil.size/-display-size-resolver/index.md)

A [SizeResolver](../coil.size/-size-resolver/index.md) that constrains a [Target](../coil.target/-target/index.md) to the size of the display.


|

##### [coil.fetch.DrawableResult](../coil.fetch/-drawable-result/index.md)

A direct [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) result. Return this from a [Fetcher](../coil.fetch/-fetcher/index.md) if its data cannot be converted into a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md).


|

##### [coil.annotation.ExperimentalCoil](../coil.annotation/-experimental-coil/index.md)

Marks declarations that are still **experimental**.
Targets marked by this annotation may contain breaking changes in the future as their design is still incubating.


|

##### [coil.fetch.Fetcher](../coil.fetch/-fetcher/index.md)

A [Fetcher](../coil.fetch/-fetcher/index.md) translates data into either a [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) or a [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html).


|

##### [coil.fetch.FetchResult](../coil.fetch/-fetch-result.md)

The result of [Fetcher.fetch](../coil.fetch/-fetcher/fetch.md).


|

##### [coil.request.GetRequest](../coil.request/-get-request/index.md)

A value object that represents a *get* image request.


|

##### [coil.request.GetRequestBuilder](../coil.request/-get-request-builder/index.md)

Builder for a [GetRequest](../coil.request/-get-request/index.md).


|

##### [coil.transform.GrayscaleTransformation](../coil.transform/-grayscale-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that converts an image to shades of gray.


|

##### [coil.network.HttpException](../coil.network/-http-exception/index.md)

Exception for an unexpected, non-2xx HTTP response.


|

##### [coil.ImageLoader](../coil/-image-loader/index.md)

Loads images using [load](../coil/-image-loader/load.md) and [get](../coil/-image-loader/get.md).


|

##### [coil.ImageLoaderBuilder](../coil/-image-loader-builder/index.md)

Builder for an [ImageLoader](../coil/-image-loader/index.md).


|

##### [coil.target.ImageViewTarget](../coil.target/-image-view-target/index.md)

A [Target](../coil.target/-target/index.md) that handles setting images on an [ImageView](https://developer.android.com/reference/android/widget/ImageView.html).


|

##### [coil.request.LoadRequest](../coil.request/-load-request/index.md)

A value object that represents a *load* image request.


|

##### [coil.request.LoadRequestBuilder](../coil.request/-load-request-builder/index.md)

Builder for a [LoadRequest](../coil.request/-load-request/index.md).


|

##### [coil.map.Mapper](../coil.map/-mapper/index.md)

An interface to convert data with type [T](../coil.map/-mapper/index.md#T) into [V](../coil.map/-mapper/index.md#V).


|

##### [coil.map.MeasuredMapper](../coil.map/-measured-mapper/index.md)

An interface to convert data with type [T](../coil.map/-measured-mapper/index.md#T) into [V](../coil.map/-measured-mapper/index.md#V).
Unlike [Mapper](../coil.map/-mapper/index.md)s, [MeasuredMapper](../coil.map/-measured-mapper/index.md) must wait for the [Target](../coil.target/-target/index.md) to be measured.
This can cause cached Drawables to not be set synchronously.


|

##### [coil.request.NullRequestDataException](../coil.request/-null-request-data-exception/index.md)

Exception for when null [Request.data](../coil.request/-request/data.md) is passed to [ImageLoader.load](../coil/-image-loader/load.md).


|

##### [coil.decode.Options](../coil.decode/-options/index.md)

A set of configuration options for fetching and decoding an image.


|

##### [coil.size.OriginalSize](../coil.size/-original-size/index.md)

Represents the width and height of the source image.


|

##### [coil.request.Parameters](../coil.request/-parameters/index.md)

A map of generic values that can be used to pass custom data to [Fetcher](../coil.fetch/-fetcher/index.md)s and [Decoder](../coil.decode/-decoder/index.md)s.


|

##### [coil.size.PixelSize](../coil.size/-pixel-size/index.md)

A positive width and height in pixels.


|

##### [coil.target.PoolableViewTarget](../coil.target/-poolable-view-target/index.md)

A [ViewTarget](../coil.target/-view-target/index.md) that supports [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) pooling.


|

##### [coil.size.Precision](../coil.size/-precision/index.md)

Represents the required precision for the size of an image in an image request.


|

##### [coil.request.Request](../coil.request/-request/index.md)

A value object that represents an image request.


|

##### [coil.request.RequestBuilder](../coil.request/-request-builder/index.md)

Base class for [LoadRequestBuilder](../coil.request/-load-request-builder/index.md) and [GetRequestBuilder](../coil.request/-get-request-builder/index.md).


|

##### [coil.request.RequestDisposable](../coil.request/-request-disposable/index.md)

Represents the work of an [ImageLoader.load](../coil/-image-loader/load.md) request.


|

##### [coil.transform.RoundedCornersTransformation](../coil.transform/-rounded-corners-transformation/index.md)

A [Transformation](../coil.transform/-transformation/index.md) that crops the image to fit the target's dimensions and rounds the corners of the image.


|

##### [coil.size.Scale](../coil.size/-scale/index.md)

Represents a scaling policy.


|

##### [coil.size.Size](../coil.size/-size.md)

Represents the target size of an image request.


|

##### [coil.size.SizeResolver](../coil.size/-size-resolver/index.md)

An interface for measuring the target size for an image request.


|

##### [coil.fetch.SourceResult](../coil.fetch/-source-result/index.md)

A raw [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.md) result, which will be consumed by the relevant [Decoder](../coil.decode/-decoder/index.md).


|

##### [coil.collection.SparseIntArraySet](../coil.collection/-sparse-int-array-set/index.md)

A collection of unordered, unique [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s.


|

##### [coil.target.Target](../coil.target/-target/index.md)

A listener that accepts the result of an image load.


|

##### [coil.transform.Transformation](../coil.transform/-transformation/index.md)

An interface for making transformations to an image's pixel data.


|

##### [coil.transition.Transition](../coil.transition/-transition/index.md)

A class to animate between a [Target](../coil.target/-target/index.md)'s current drawable and the result of an image request.


|

##### [coil.transition.TransitionResult](../coil.transition/-transition-result/index.md)

Represents the result of an image request.


|

##### [coil.transition.TransitionTarget](../coil.transition/-transition-target/index.md)

A [Target](../coil.target/-target/index.md) that supports applying [Transition](../coil.transition/-transition/index.md)s.


|

##### [coil.size.ViewSizeResolver](../coil.size/-view-size-resolver/index.md)

A [SizeResolver](../coil.size/-size-resolver/index.md) that measures the size of a [View](https://developer.android.com/reference/android/view/View.html).


|

##### [coil.target.ViewTarget](../coil.target/-view-target/index.md)

A [Target](../coil.target/-target/index.md) with an associated [View](https://developer.android.com/reference/android/view/View.html).


