[coil-base](../../index.md) / [coil.collection](../index.md) / [SparseIntArraySet](./index.md)

# SparseIntArraySet

`class SparseIntArraySet`

A collection of unordered, unique [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s.

This data structure is intended to be more memory efficient than using a [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html) to store [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s, both
because it avoids auto-boxing elements and it doesn't allocate a hash table.

**See Also**

[SparseIntArray](https://developer.android.com/reference/android/util/SparseIntArray.html)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A collection of unordered, unique [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)s.`SparseIntArraySet(initialCapacity: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = 10)` |

### Functions

| Name | Summary |
|---|---|
| [add](add.md) | Adds an element to the set.`fun add(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [clear](clear.md) | Removes all elements from this SparseIntArraySet.`fun clear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [contains](contains.md) | Return true if the SparseIntArraySet contains this element.`fun contains(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [elementAt](element-at.md) | Given an index in the range `[0, size)`, returns the element from the `index`th key-value mapping that this SparseIntArraySet stores.`fun elementAt(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [indexOfElement](index-of-element.md) | Returns the index for which [elementAt](element-at.md) would return the specified element, or a negative number if the specified element is not mapped.`fun indexOfElement(key: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [remove](remove.md) | Removes the element from the set. Return true if it was present.`fun remove(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [removeAt](remove-at.md) | Removes the element at the given index.`fun removeAt(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [size](size.md) | Returns the number of elements that this SparseIntArraySet currently stores.`fun size(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [addAll](../../coil.extension/add-all.md) | `fun `[`SparseIntArraySet`](./index.md)`.addAll(other: `[`SparseIntArraySet`](./index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [forEach](../../coil.extension/for-each.md) | `fun `[`SparseIntArraySet`](./index.md)`.forEach(action: (element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [isEmpty](../../coil.extension/is-empty.md) | `fun `[`SparseIntArraySet`](./index.md)`.isEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isNotEmpty](../../coil.extension/is-not-empty.md) | `fun `[`SparseIntArraySet`](./index.md)`.isNotEmpty(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [minusAssign](../../coil.extension/minus-assign.md) | `operator fun `[`SparseIntArraySet`](./index.md)`.minusAssign(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [plus](../../coil.extension/plus.md) | `operator fun `[`SparseIntArraySet`](./index.md)`.plus(other: `[`SparseIntArraySet`](./index.md)`): `[`SparseIntArraySet`](./index.md) |
| [plusAssign](../../coil.extension/plus-assign.md) | `operator fun `[`SparseIntArraySet`](./index.md)`.plusAssign(element: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
