[coil-base](../../index.md) / [coil.request](../index.md) / [Request](./index.md)

# Request

`sealed class Request`

A value object that represents an image request.

**See Also**

[LoadRequest](../-load-request/index.md)

[GetRequest](../-get-request/index.md)

### Types

| Name | Summary |
|---|---|
| [Listener](-listener/index.md) | A set of callbacks for a [Request](./index.md).`interface Listener` |

### Properties

| Name | Summary |
|---|---|
| [aliasKeys](alias-keys.md) | `abstract val aliasKeys: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`>` |
| [allowHardware](allow-hardware.md) | `abstract val allowHardware: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [allowRgb565](allow-rgb565.md) | `abstract val allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [bitmapConfig](bitmap-config.md) | `abstract val bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html) |
| [colorSpace](color-space.md) | `abstract val colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?` |
| [data](data.md) | `abstract val data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [decoder](decoder.md) | `abstract val decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`?` |
| [diskCachePolicy](disk-cache-policy.md) | `abstract val diskCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [dispatcher](dispatcher.md) | `abstract val dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) |
| [error](error.md) | `abstract val error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [fallback](fallback.md) | `abstract val fallback: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [headers](headers.md) | `abstract val headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) |
| [key](key.md) | `abstract val key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [lifecycle](lifecycle.md) | `abstract val lifecycle: `[`Lifecycle`](https://developer.android.com/reference/androidx/androidx/lifecycle/Lifecycle.html)`?` |
| [listener](listener.md) | `abstract val listener: Listener?` |
| [memoryCachePolicy](memory-cache-policy.md) | `abstract val memoryCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [networkCachePolicy](network-cache-policy.md) | `abstract val networkCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [parameters](parameters.md) | `abstract val parameters: `[`Parameters`](../-parameters/index.md) |
| [placeholder](placeholder.md) | `abstract val placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [precision](precision.md) | `abstract val precision: `[`Precision`](../../coil.size/-precision/index.md) |
| [scale](scale.md) | `abstract val scale: `[`Scale`](../../coil.size/-scale/index.md)`?` |
| [sizeResolver](size-resolver.md) | `abstract val sizeResolver: `[`SizeResolver`](../../coil.size/-size-resolver/index.md)`?` |
| [target](target.md) | `abstract val target: `[`Target`](../../coil.target/-target/index.md)`?` |
| [transformations](transformations.md) | `abstract val transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../coil.transform/-transformation/index.md)`>` |
| [transition](transition.md) | `abstract val transition: `[`Transition`](../../coil.transition/-transition/index.md)`?` |

### Inheritors

| Name | Summary |
|---|---|
| [GetRequest](../-get-request/index.md) | A value object that represents a *get* image request.`class GetRequest : `[`Request`](./index.md) |
| [LoadRequest](../-load-request/index.md) | A value object that represents a *load* image request.`class LoadRequest : `[`Request`](./index.md) |
