[coil-base](../../index.md) / [coil.drawable](../index.md) / [CrossfadeDrawable](./index.md)

# CrossfadeDrawable

`class CrossfadeDrawable : `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, `[`Callback`](https://developer.android.com/reference/android/graphics/drawable/Drawable/Callback.html)`, `[`Animatable2Compat`](https://developer.android.com/reference/androidx/vectordrawable/graphics/drawable/Animatable2Compat.html)

A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that crossfades from [start](start.md) to [end](#).

NOTE: The animation can only be executed once as the [start](start.md) drawable is dereferenced at the end of the transition.

### Parameters

`start` - The [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) to crossfade from.

`end` - The [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) to crossfade to.

`scale` - The scaling algorithm for [start](start.md) and [end](#).

`durationMillis` - The duration of the crossfade animation.

`fadeStart` - If false, the start drawable will not fade out while the end drawable fades in.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that crossfades from [start](start.md) to [end](#).`CrossfadeDrawable(start: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, end: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?, scale: `[`Scale`](../../coil.size/-scale/index.md)` = Scale.FIT, durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)` = DEFAULT_DURATION, fadeStart: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true)` |

### Properties

| Name | Summary |
|---|---|
| [durationMillis](duration-millis.md) | The duration of the crossfade animation.`val durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [fadeStart](fade-start.md) | If false, the start drawable will not fade out while the end drawable fades in.`val fadeStart: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [scale](scale.md) | The scaling algorithm for [start](start.md) and [end](#).`val scale: `[`Scale`](../../coil.size/-scale/index.md) |

### Functions

| Name | Summary |
|---|---|
| [clearAnimationCallbacks](clear-animation-callbacks.md) | `fun clearAnimationCallbacks(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [draw](draw.md) | `fun draw(canvas: `[`Canvas`](https://developer.android.com/reference/android/graphics/Canvas.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [getAlpha](get-alpha.md) | `fun getAlpha(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getColorFilter](get-color-filter.md) | `fun getColorFilter(): `[`ColorFilter`](https://developer.android.com/reference/android/graphics/ColorFilter.html)`?` |
| [getIntrinsicHeight](get-intrinsic-height.md) | `fun getIntrinsicHeight(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getIntrinsicWidth](get-intrinsic-width.md) | `fun getIntrinsicWidth(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getOpacity](get-opacity.md) | `fun getOpacity(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [invalidateDrawable](invalidate-drawable.md) | `fun invalidateDrawable(who: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [isRunning](is-running.md) | `fun isRunning(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onBoundsChange](on-bounds-change.md) | `fun onBoundsChange(bounds: `[`Rect`](https://developer.android.com/reference/android/graphics/Rect.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onLevelChange](on-level-change.md) | `fun onLevelChange(level: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onStateChange](on-state-change.md) | `fun onStateChange(state: `[`IntArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int-array/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [registerAnimationCallback](register-animation-callback.md) | `fun registerAnimationCallback(callback: `[`AnimationCallback`](https://developer.android.com/reference/androidx/vectordrawable/graphics/drawable/Animatable2Compat/AnimationCallback.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [scheduleDrawable](schedule-drawable.md) | `fun scheduleDrawable(who: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, what: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`, when: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setAlpha](set-alpha.md) | `fun setAlpha(alpha: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setColorFilter](set-color-filter.md) | `fun setColorFilter(colorFilter: `[`ColorFilter`](https://developer.android.com/reference/android/graphics/ColorFilter.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTint](set-tint.md) | `fun setTint(tintColor: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTintBlendMode](set-tint-blend-mode.md) | `fun setTintBlendMode(blendMode: `[`BlendMode`](https://developer.android.com/reference/android/graphics/BlendMode.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTintList](set-tint-list.md) | `fun setTintList(tint: `[`ColorStateList`](https://developer.android.com/reference/android/content/res/ColorStateList.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setTintMode](set-tint-mode.md) | `fun setTintMode(tintMode: `[`Mode`](https://developer.android.com/reference/android/graphics/PorterDuff/Mode.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [start](start.md) | `fun start(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [stop](stop.md) | `fun stop(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [unregisterAnimationCallback](unregister-animation-callback.md) | `fun unregisterAnimationCallback(callback: `[`AnimationCallback`](https://developer.android.com/reference/androidx/vectordrawable/graphics/drawable/Animatable2Compat/AnimationCallback.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [unscheduleDrawable](unschedule-drawable.md) | `fun unscheduleDrawable(who: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, what: `[`Runnable`](https://docs.oracle.com/javase/8/docs/api/java/lang/Runnable.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [DEFAULT_DURATION](-d-e-f-a-u-l-t_-d-u-r-a-t-i-o-n.md) | `const val DEFAULT_DURATION: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
