[coil-base](../../index.md) / [coil.request](../index.md) / [ImageRequest](./index.md)

# ImageRequest

`class ImageRequest`

An immutable value object that represents a request for an image.

**See Also**

[ImageLoader.enqueue](../../coil/-image-loader/enqueue.md)

[ImageLoader.execute](../../coil/-image-loader/execute.md)

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |
| [Listener](-listener/index.md) | A set of callbacks for an [ImageRequest](./index.md).`interface Listener` |

### Properties

| Name | Summary |
|---|---|
| [allowHardware](allow-hardware.md) | `val allowHardware: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [allowRgb565](allow-rgb565.md) | `val allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [bitmapConfig](bitmap-config.md) | `val bitmapConfig: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html) |
| [colorSpace](color-space.md) | `val colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`?` |
| [context](context.md) | `val context: `[`Context`](https://developer.android.com/reference/android/content/Context.html) |
| [data](data.md) | `val data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html) |
| [decoder](decoder.md) | `val decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`?` |
| [defaults](defaults.md) | The defaults used to fill unset values.`val defaults: `[`DefaultRequestOptions`](../-default-request-options/index.md) |
| [defined](defined.md) | The raw values set on [Builder](-builder/index.md).`val defined: `[`DefinedRequestOptions`](../-defined-request-options/index.md) |
| [diskCachePolicy](disk-cache-policy.md) | `val diskCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [dispatcher](dispatcher.md) | `val dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) |
| [error](error.md) | `val error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [fallback](fallback.md) | `val fallback: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [fetcher](fetcher.md) | `val fetcher: `[`Pair`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)`<`[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>, `[`Class`](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<*>>?` |
| [headers](headers.md) | `val headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) |
| [lifecycle](lifecycle.md) | `val lifecycle: `[`Lifecycle`](https://developer.android.com/reference/androidx/lifecycle/Lifecycle.html) |
| [listener](listener.md) | `val listener: Listener?` |
| [memoryCacheKey](memory-cache-key.md) | `val memoryCacheKey: Key?` |
| [memoryCachePolicy](memory-cache-policy.md) | `val memoryCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [networkCachePolicy](network-cache-policy.md) | `val networkCachePolicy: `[`CachePolicy`](../-cache-policy/index.md) |
| [parameters](parameters.md) | `val parameters: `[`Parameters`](../-parameters/index.md) |
| [placeholder](placeholder.md) | `val placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?` |
| [placeholderMemoryCacheKey](placeholder-memory-cache-key.md) | `val placeholderMemoryCacheKey: Key?` |
| [precision](precision.md) | `val precision: `[`Precision`](../../coil.size/-precision/index.md) |
| [scale](scale.md) | `val scale: `[`Scale`](../../coil.size/-scale/index.md) |
| [sizeResolver](size-resolver.md) | `val sizeResolver: `[`SizeResolver`](../../coil.size/-size-resolver/index.md) |
| [target](target.md) | `val target: `[`Target`](../../coil.target/-target/index.md)`?` |
| [transformations](transformations.md) | `val transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../coil.transform/-transformation/index.md)`>` |
| [transition](transition.md) | `val transition: `[`Transition`](../../coil.transition/-transition/index.md) |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [newBuilder](new-builder.md) | `fun newBuilder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)` = this.context): Builder` |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
