[coil-base](../../index.md) / [coil](../index.md) / [EventListener](./index.md)

# EventListener

`@ExperimentalCoilApi interface EventListener : Listener`

A listener for tracking the progress of an image request. This class is useful for
measuring analytics, performance, or other metrics tracking.

**See Also**

[ImageLoader.Builder.eventListener](../-image-loader/-builder/event-listener.md)

### Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | A factory that creates new [EventListener](./index.md) instances.`interface Factory` |

### Functions

| Name | Summary |
|---|---|
| [decodeEnd](decode-end.md) | Called after [Decoder.decode](../../coil.decode/-decoder/decode.md).`open fun decodeEnd(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`, options: `[`Options`](../../coil.decode/-options/index.md)`, result: `[`DecodeResult`](../../coil.decode/-decode-result/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [decodeStart](decode-start.md) | Called before [Decoder.decode](../../coil.decode/-decoder/decode.md).`open fun decodeStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, decoder: `[`Decoder`](../../coil.decode/-decoder/index.md)`, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [fetchEnd](fetch-end.md) | Called after [Fetcher.fetch](../../coil.fetch/-fetcher/fetch.md).`open fun fetchEnd(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, fetcher: `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>, options: `[`Options`](../../coil.decode/-options/index.md)`, result: `[`FetchResult`](../../coil.fetch/-fetch-result.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [fetchStart](fetch-start.md) | Called before [Fetcher.fetch](../../coil.fetch/-fetcher/fetch.md).`open fun fetchStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, fetcher: `[`Fetcher`](../../coil.fetch/-fetcher/index.md)`<*>, options: `[`Options`](../../coil.decode/-options/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [mapEnd](map-end.md) | Called after [Mapper.map](../../coil.map/-mapper/map.md).`open fun mapEnd(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, output: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [mapStart](map-start.md) | Called before [Mapper.map](../../coil.map/-mapper/map.md).`open fun mapStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, input: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onCancel](on-cancel.md) | `open fun onCancel(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onError](on-error.md) | `open fun onError(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, throwable: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onStart](on-start.md) | `open fun onStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onSuccess](on-success.md) | `open fun onSuccess(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, metadata: Metadata): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [resolveSizeEnd](resolve-size-end.md) | Called after [SizeResolver.size](../../coil.size/-size-resolver/size.md).`open fun resolveSizeEnd(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, size: `[`Size`](../../coil.size/-size.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [resolveSizeStart](resolve-size-start.md) | Called before [SizeResolver.size](../../coil.size/-size-resolver/size.md).`open fun resolveSizeStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transformEnd](transform-end.md) | Called after any [Transformation](../../coil.transform/-transformation/index.md)s are applied.`open fun transformEnd(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, output: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transformStart](transform-start.md) | Called before any [Transformation](../../coil.transform/-transformation/index.md)s are applied.`open fun transformStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`, input: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transitionEnd](transition-end.md) | Called after [Transition.transition](../../coil.transition/-transition/transition.md).`open fun transitionEnd(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [transitionStart](transition-start.md) | Called before [Transition.transition](../../coil.transition/-transition/transition.md).`open fun transitionStart(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [NONE](-n-o-n-e.md) | `val NONE: `[`EventListener`](./index.md) |
