[coil-gif](../../index.md) / [coil.drawable](../index.md) / [MovieDrawable](./index.md)

# MovieDrawable

`class MovieDrawable : `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`, `[`Animatable2Compat`](https://developer.android.com/reference/androidx/vectordrawable/graphics/drawable/Animatable2Compat.html)

A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that supports rendering [Movie](https://developer.android.com/reference/android/graphics/Movie.html)s (i.e. GIFs).

NOTE: Prefer using [ImageDecoderDecoder](https://coil-kt.github.io/coil/api/coil-base/coil.decode/-image-decoder-decoder/index.html) and [AnimatedImageDrawable](https://developer.android.com/reference/android/graphics/drawable/AnimatedImageDrawable.html) on API 28 and above.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) that supports rendering [Movie](https://developer.android.com/reference/android/graphics/Movie.html)s (i.e. GIFs).`MovieDrawable(movie: `[`Movie`](https://developer.android.com/reference/android/graphics/Movie.html)`, pool: `[`BitmapPool`](https://coil-kt.github.io/coil/api/coil-base/coil.bitmap/-bitmap-pool/index.html)`, config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)` = Bitmap.Config.ARGB_8888, scale: `[`Scale`](https://coil-kt.github.io/coil/api/coil-base/coil.size/-scale/index.html)` = Scale.FIT)` |

### Properties

| Name | Summary |
|---|---|
| [config](config.md) | `val config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html) |
| [scale](scale.md) | `val scale: `[`Scale`](https://coil-kt.github.io/coil/api/coil-base/coil.size/-scale/index.html) |

### Functions

| Name | Summary |
|---|---|
| [clearAnimationCallbacks](clear-animation-callbacks.md) | `fun clearAnimationCallbacks(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [draw](draw.md) | `fun draw(canvas: `[`Canvas`](https://developer.android.com/reference/android/graphics/Canvas.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [getIntrinsicHeight](get-intrinsic-height.md) | `fun getIntrinsicHeight(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getIntrinsicWidth](get-intrinsic-width.md) | `fun getIntrinsicWidth(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getOpacity](get-opacity.md) | `fun getOpacity(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getRepeatCount](get-repeat-count.md) | Get the number of times the animation will repeat.`fun getRepeatCount(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [isRunning](is-running.md) | `fun isRunning(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onBoundsChange](on-bounds-change.md) | `fun onBoundsChange(bounds: `[`Rect`](https://developer.android.com/reference/android/graphics/Rect.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [registerAnimationCallback](register-animation-callback.md) | `fun registerAnimationCallback(callback: `[`AnimationCallback`](https://developer.android.com/reference/androidx/vectordrawable/graphics/drawable/Animatable2Compat/AnimationCallback.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setAlpha](set-alpha.md) | `fun setAlpha(alpha: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setColorFilter](set-color-filter.md) | `fun setColorFilter(colorFilter: `[`ColorFilter`](https://developer.android.com/reference/android/graphics/ColorFilter.html)`?): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [setRepeatCount](set-repeat-count.md) | Set the number of times to repeat the animation.`fun setRepeatCount(repeatCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [start](start.md) | `fun start(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [stop](stop.md) | `fun stop(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [unregisterAnimationCallback](unregister-animation-callback.md) | `fun unregisterAnimationCallback(callback: `[`AnimationCallback`](https://developer.android.com/reference/androidx/vectordrawable/graphics/drawable/Animatable2Compat/AnimationCallback.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [REPEAT_INFINITE](-r-e-p-e-a-t_-i-n-f-i-n-i-t-e.md) | Pass this to [setRepeatCount](https://coil-kt.github.io/coil/api/coil-base/coil.drawable/-movie-drawable/set-repeat-count.html) to repeat infinitely.`const val REPEAT_INFINITE: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
