[coil-base](../../index.md) / [coil.memory](../index.md) / [MemoryCache](./index.md)

# MemoryCache

`interface MemoryCache`

An in-memory cache of recently loaded images.

### Types

| Name | Summary |
|---|---|
| [Key](-key/index.md) | The cache key for an image in the memory cache.`sealed class Key : `[`Parcelable`](https://developer.android.com/reference/android/os/Parcelable.html) |

### Properties

| Name | Summary |
|---|---|
| [maxSize](max-size.md) | The maximum size of the cache in bytes.`abstract val maxSize: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [size](size.md) | The current size of the cache in bytes.`abstract val size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Functions

| Name | Summary |
|---|---|
| [clear](clear.md) | Remove all values from the memory cache.`abstract fun clear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [get](get.md) | Get the [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) associated with [key](get.md#coil.memory.MemoryCache$get(coil.memory.MemoryCache.Key)/key).`abstract operator fun get(key: Key): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`?` |
| [remove](remove.md) | Remove the [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) referenced by [key](remove.md#coil.memory.MemoryCache$remove(coil.memory.MemoryCache.Key)/key).`abstract fun remove(key: Key): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [set](set.md) | Set the [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) associated with [key](set.md#coil.memory.MemoryCache$set(coil.memory.MemoryCache.Key, android.graphics.Bitmap)/key).`abstract operator fun set(key: Key, bitmap: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
