[coil-base](../../index.md) / [coil.target](../index.md) / [PoolableViewTarget](./index.md)

# PoolableViewTarget

`interface PoolableViewTarget<T : `[`View`](https://developer.android.com/reference/android/view/View.html)`> : `[`ViewTarget`](../-view-target/index.md)`<T>`

A [ViewTarget](../-view-target/index.md) that supports [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) pooling.

Implementing [PoolableViewTarget](./index.md) opts this target into bitmap pooling. This allows Coil to re-use [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s
given to this target, which can conserve memory by avoiding a new [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html) allocation.

To opt out of bitmap pooling, implement [ViewTarget](../-view-target/index.md) instead.

Implementing [PoolableViewTarget](./index.md) requires that you must stop using the previous [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) as soon as
the next [PoolableViewTarget](./index.md) lifecycle method is called; one of:

[Target.onStart](../-target/on-start.md), [Target.onSuccess](../-target/on-success.md), [Target.onError](../-target/on-error.md), [PoolableViewTarget.onClear](on-clear.md).

For example, a [PoolableViewTarget](./index.md) must stop using the placeholder drawable from [Target.onStart](../-target/on-start.md)
as soon as [Target.onSuccess](../-target/on-success.md) is called.

Continuing to use the previous [Drawable](https://developer.android.com/reference/android/graphics/drawable/Drawable.html) after the next lifecycle method is called can cause rendering issues
and/or throw exceptions.

**See Also**

[ViewTarget](../-view-target/index.md)

[ImageViewTarget](../-image-view-target/index.md)

### Functions

| Name | Summary |
|---|---|
| [onClear](on-clear.md) | Called when the current drawable is no longer usable. Targets **must** stop using the current Drawable.`abstract fun onClear(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [ImageViewTarget](../-image-view-target/index.md) | A [Target](../-target/index.md) that handles setting images on an [ImageView](https://developer.android.com/reference/android/widget/ImageView.html).`open class ImageViewTarget : `[`PoolableViewTarget`](./index.md)`<`[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`>, `[`TransitionTarget`](../../coil.transition/-transition-target/index.md)`, `[`DefaultLifecycleObserver`](https://developer.android.com/reference/androidx/lifecycle/DefaultLifecycleObserver.html) |
