[coil-base](../../index.md) / [coil.transform](../index.md) / [RoundedCornersTransformation](./index.md)

# RoundedCornersTransformation

`class RoundedCornersTransformation : `[`Transformation`](../-transformation/index.md)

A [Transformation](../-transformation/index.md) that crops the image to fit the target's dimensions and rounds the corners of the image.

### Parameters

`topLeft` - The radius for the top left corner.

`topRight` - The radius for the top right corner.

`bottomLeft` - The radius for the bottom left corner.

`bottomRight` - The radius for the bottom right corner.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `RoundedCornersTransformation(radius: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)`)`<br>A [Transformation](../-transformation/index.md) that crops the image to fit the target's dimensions and rounds the corners of the image.`RoundedCornersTransformation(topLeft: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)` = 0f, topRight: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)` = 0f, bottomLeft: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)` = 0f, bottomRight: `[`Float`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-float/index.html)` = 0f)` |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [key](key.md) | Return a unique key for this transformation.`fun key(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [transform](transform.md) | Apply the transformation to [input](../-transformation/transform.md#coil.transform.Transformation$transform(coil.bitmap.BitmapPool, android.graphics.Bitmap, coil.size.Size)/input).`suspend fun transform(pool: `[`BitmapPool`](../../coil.bitmap/-bitmap-pool/index.md)`, input: `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html)`, size: `[`Size`](../../coil.size/-size.md)`): `[`Bitmap`](https://developer.android.com/reference/android/graphics/Bitmap.html) |
