[coil-base](../../../index.md) / [coil](../../index.md) / [ImageLoader](../index.md) / [Builder](index.md) / [callFactory](./call-factory.md)

# callFactory

`fun callFactory(callFactory: `[`Factory`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html)`): Builder`

Set the [Call.Factory](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html) used for network requests.

Calling [okHttpClient](ok-http-client.md) automatically sets this value.

NOTE: You must set [OkHttpClient.cache](https://square.github.io/okhttp/3.x/okhttp/okhttp3/OkHttpClient.html#cache()) to enable disk caching. A default
Coil disk cache instance can be created using [CoilUtils.createDefaultCache](../../../coil.util/-coil-utils/create-default-cache.md).

`fun callFactory(initializer: () -> `[`Factory`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html)`): Builder`

Set a lazy callback to create the [Call.Factory](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html) used for network requests.

This allows lazy creation of the [Call.Factory](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Call/Factory.html) on a background thread.
[initializer](call-factory.md#coil.ImageLoader.Builder$callFactory(kotlin.Function0((okhttp3.Call.Factory)))/initializer) is guaranteed to be called at most once.

Prefer using this instead of `callFactory(Call.Factory)`.

Calling [okHttpClient](ok-http-client.md) automatically sets this value.

NOTE: You must set [OkHttpClient.cache](https://square.github.io/okhttp/3.x/okhttp/okhttp3/OkHttpClient.html#cache()) to enable disk caching. A default
Coil disk cache instance can be created using [CoilUtils.createDefaultCache](../../../coil.util/-coil-utils/create-default-cache.md).

