[coil-gif](../../index.md) / [coil.drawable](../index.md) / [MovieDrawable](index.md) / [setRepeatCount](./set-repeat-count.md)

# setRepeatCount

`fun setRepeatCount(repeatCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)

Set the number of times to repeat the animation.

If the animation is already running, any iterations that have already occurred will count towards the new count.

NOTE: This method matches the behavior of [AnimatedImageDrawable.setRepeatCount](https://developer.android.com/reference/android/graphics/drawable/AnimatedImageDrawable.html#setRepeatCount(int)). i.e. setting [repeatCount](https://coil-kt.github.io/coil/api/coil-base/coil.drawable/-movie-drawable/set-repeat-count/repeat-count.html) to 2 will
result in the animation playing 3 times. Setting [repeatCount](https://coil-kt.github.io/coil/api/coil-base/coil.drawable/-movie-drawable/set-repeat-count/repeat-count.html) to 0 will result in the animation playing once.

Default: [REPEAT_INFINITE](https://coil-kt.github.io/coil/api/coil-base/coil.drawable/-movie-drawable/-companion/-r-e-p-e-a-t_-i-n-f-i-n-i-t-e.html)

