[coil-base](../../index.md) / [coil.decode](../index.md) / [Options](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`Options(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`, config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)` = Bitmap.Config.ARGB_8888, colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`? = NULL_COLOR_SPACE, scale: `[`Scale`](../../coil.size/-scale/index.md)` = Scale.FIT, allowInexactSize: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, allowRgb565: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, premultipliedAlpha: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true, headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html)` = EMPTY_HEADERS, parameters: `[`Parameters`](../../coil.request/-parameters/index.md)` = Parameters.EMPTY, memoryCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)` = CachePolicy.ENABLED, diskCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)` = CachePolicy.ENABLED, networkCachePolicy: `[`CachePolicy`](../../coil.request/-cache-policy/index.md)` = CachePolicy.ENABLED)`

A set of configuration options for fetching and decoding an image.

[Fetcher](../../coil.fetch/-fetcher/index.md)s and [Decoder](../-decoder/index.md)s should respect these options as best as possible.

### Parameters

`context` - The [Context](https://developer.android.com/reference/android/content/Context.html) used to execute this request.

`config` - The requested config for any [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s.

`colorSpace` - The preferred color space for any [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s.
If null, components should typically default to [ColorSpace.Rgb](https://developer.android.com/reference/android/graphics/ColorSpace/Rgb.html).

`scale` - The scaling algorithm for how to fit the source image's dimensions into the target's dimensions.

`allowInexactSize` - True if the output image does not need to fit/fill the target's dimensions exactly. For instance,
if true [BitmapFactoryDecoder](#) will not decode an image at a larger size than its source dimensions as an optimization.

`allowRgb565` - True if a component is allowed to use [Bitmap.Config.RGB_565](https://developer.android.com/reference/android/graphics/Bitmap/Config.html#RGB_565) as an optimization. As RGB_565 does
not have an alpha channel, components should only use RGB_565 if the image is guaranteed to not use alpha.

`premultipliedAlpha` - True if the color (RGB) channels of the decoded image should be pre-multiplied by the
alpha channel. The default behavior is to enable pre-multiplication but in some environments it can be necessary
to disable this feature to leave the source pixels unmodified.

`headers` - The header fields to use for any network requests.

`parameters` - A map of custom parameters. These are used to pass custom data to a component.

`memoryCachePolicy` - Determines if this request is allowed to read/write from/to memory.

`diskCachePolicy` - Determines if this request is allowed to read/write from/to disk.

`networkCachePolicy` - Determines if this request is allowed to read from the network.