[coil-base](../../../index.md) / [coil.request](../../index.md) / [ImageRequest](../index.md) / [Builder](./index.md)

# Builder

`class Builder`

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Builder(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`)`<br>`Builder(request: `[`ImageRequest`](../index.md)`, context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)` = request.context)` |

### Functions

| Name | Summary |
|---|---|
| [addHeader](add-header.md) | Add a header for any network operations performed by this request.`fun addHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): Builder` |
| [allowHardware](allow-hardware.md) | `fun allowHardware(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Builder` |
| [allowRgb565](allow-rgb565.md) | `fun allowRgb565(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Builder` |
| [bitmapConfig](bitmap-config.md) | `fun bitmapConfig(config: `[`Config`](https://developer.android.com/reference/android/graphics/Bitmap/Config.html)`): Builder` |
| [build](build.md) | Create a new [ImageRequest](../index.md).`fun build(): `[`ImageRequest`](../index.md) |
| [colorSpace](color-space.md) | Set the preferred [ColorSpace](https://developer.android.com/reference/android/graphics/ColorSpace.html).`fun colorSpace(colorSpace: `[`ColorSpace`](https://developer.android.com/reference/android/graphics/ColorSpace.html)`): Builder` |
| [crossfade](crossfade.md) | `fun crossfade(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Builder`<br>`fun crossfade(durationMillis: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Builder` |
| [data](data.md) | Set the data to load.`fun data(data: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): Builder` |
| [decoder](decoder.md) | Use [decoder](decoder.md#coil.request.ImageRequest.Builder$decoder(coil.decode.Decoder)/decoder) to handle decoding any image data.`fun decoder(decoder: `[`Decoder`](../../../coil.decode/-decoder/index.md)`): Builder` |
| [defaults](defaults.md) | Set the defaults for any unset request values.`fun defaults(defaults: `[`DefaultRequestOptions`](../../-default-request-options/index.md)`): Builder` |
| [diskCachePolicy](disk-cache-policy.md) | Enable/disable reading/writing from/to the disk cache.`fun diskCachePolicy(policy: `[`CachePolicy`](../../-cache-policy/index.md)`): Builder` |
| [dispatcher](dispatcher.md) | Set the [CoroutineDispatcher](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html) to launch the request.`fun dispatcher(dispatcher: `[`CoroutineDispatcher`](https://kotlin.github.io/kotlinx.coroutines/kotlinx-coroutines-core/kotlinx.coroutines/-coroutine-dispatcher/index.html)`): Builder` |
| [error](error.md) | Set the error drawable to use if the request fails.`fun error(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Builder`<br>`fun error(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): Builder` |
| [fallback](fallback.md) | Set the fallback drawable to use if [data](data.md) is null.`fun fallback(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Builder`<br>`fun fallback(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): Builder` |
| [fetcher](fetcher.md) | Use [fetcher](fetcher.md#coil.request.ImageRequest.Builder$fetcher(coil.fetch.Fetcher((coil.request.ImageRequest.Builder.fetcher.T)))/fetcher) to handle fetching any image data.`fun <T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> fetcher(fetcher: `[`Fetcher`](../../../coil.fetch/-fetcher/index.md)`<T>): Builder` |
| [headers](headers.md) | Set the [Headers](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html) for any network operations performed by this request.`fun headers(headers: `[`Headers`](https://square.github.io/okhttp/3.x/okhttp/okhttp3/Headers.html)`): Builder` |
| [lifecycle](lifecycle.md) | Set the [Lifecycle](https://developer.android.com/reference/androidx/lifecycle/Lifecycle.html) for this request.`fun lifecycle(owner: `[`LifecycleOwner`](https://developer.android.com/reference/androidx/lifecycle/LifecycleOwner.html)`?): Builder`<br>`fun lifecycle(lifecycle: `[`Lifecycle`](https://developer.android.com/reference/androidx/lifecycle/Lifecycle.html)`?): Builder` |
| [listener](listener.md) | Convenience function to create and set the [Listener](../-listener/index.md).`fun listener(onStart: (request: `[`ImageRequest`](../index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onCancel: (request: `[`ImageRequest`](../index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onError: (request: `[`ImageRequest`](../index.md)`, throwable: `[`Throwable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = { _, _ -> }, onSuccess: (request: `[`ImageRequest`](../index.md)`, metadata: Metadata) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = { _, _ -> }): Builder`<br>Set the [Listener](../-listener/index.md).`fun listener(listener: Listener?): Builder` |
| [memoryCacheKey](memory-cache-key.md) | Set the memory cache key for this request.`fun memoryCacheKey(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): Builder`<br>`fun memoryCacheKey(key: Key?): Builder` |
| [memoryCachePolicy](memory-cache-policy.md) | Enable/disable reading/writing from/to the memory cache.`fun memoryCachePolicy(policy: `[`CachePolicy`](../../-cache-policy/index.md)`): Builder` |
| [networkCachePolicy](network-cache-policy.md) | Enable/disable reading from the network.`fun networkCachePolicy(policy: `[`CachePolicy`](../../-cache-policy/index.md)`): Builder` |
| [parameters](parameters.md) | Set the parameters for this request.`fun parameters(parameters: `[`Parameters`](../../-parameters/index.md)`): Builder` |
| [placeholder](placeholder.md) | Set the placeholder drawable to use when the request starts.`fun placeholder(drawableResId: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Builder`<br>`fun placeholder(drawable: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?): Builder` |
| [placeholderMemoryCacheKey](placeholder-memory-cache-key.md) | Set the memory cache [key](placeholder-memory-cache-key.md#coil.request.ImageRequest.Builder$placeholderMemoryCacheKey(kotlin.String)/key) whose value will be used as the placeholder drawable.`fun placeholderMemoryCacheKey(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): Builder`<br>`fun placeholderMemoryCacheKey(key: Key?): Builder` |
| [precision](precision.md) | Set the precision for the size of the loaded image.`fun precision(precision: `[`Precision`](../../../coil.size/-precision/index.md)`): Builder` |
| [premultipliedAlpha](premultiplied-alpha.md) | Enable/disable pre-multiplication of the color (RGB) channels of the decoded image by the alpha channel.`fun premultipliedAlpha(enable: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): Builder` |
| [removeHeader](remove-header.md) | Remove all network headers with the key [name](remove-header.md#coil.request.ImageRequest.Builder$removeHeader(kotlin.String)/name).`fun removeHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): Builder` |
| [removeParameter](remove-parameter.md) | Remove a parameter from this request.`fun removeParameter(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): Builder` |
| [scale](scale.md) | Set the scaling algorithm that will be used to fit/fill the image into the size provided by [sizeResolver](#).`fun scale(scale: `[`Scale`](../../../coil.size/-scale/index.md)`): Builder` |
| [setHeader](set-header.md) | Set a header for any network operations performed by this request.`fun setHeader(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): Builder` |
| [setParameter](set-parameter.md) | Set a parameter for this request.`fun setParameter(key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, cacheKey: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`? = value?.toString()): Builder` |
| [size](size.md) | Set the requested width/height.`fun size(size: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Builder`<br>`fun size(width: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, height: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): Builder`<br>`fun size(size: `[`Size`](../../../coil.size/-size.md)`): Builder`<br>Set the [SizeResolver](../../../coil.size/-size-resolver/index.md) to resolve the requested width/height.`fun size(resolver: `[`SizeResolver`](../../../coil.size/-size-resolver/index.md)`): Builder` |
| [target](target.md) | Convenience function to set [imageView](target.md#coil.request.ImageRequest.Builder$target(android.widget.ImageView)/imageView) as the [Target](../../../coil.target/-target/index.md).`fun target(imageView: `[`ImageView`](https://developer.android.com/reference/android/widget/ImageView.html)`): Builder`<br>Convenience function to create and set the [Target](../../../coil.target/-target/index.md).`fun target(onStart: (placeholder: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onError: (error: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`?) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}, onSuccess: (result: `[`Drawable`](https://developer.android.com/reference/android/graphics/drawable/Drawable.html)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)` = {}): Builder`<br>Set the [Target](../../../coil.target/-target/index.md).`fun target(target: `[`Target`](../../../coil.target/-target/index.md)`?): Builder` |
| [transformations](transformations.md) | Set the list of [Transformation](../../../coil.transform/-transformation/index.md)s to be applied to this request.`fun transformations(vararg transformations: `[`Transformation`](../../../coil.transform/-transformation/index.md)`): Builder`<br>`fun transformations(transformations: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Transformation`](../../../coil.transform/-transformation/index.md)`>): Builder` |
| [transition](transition.md) | `fun transition(transition: `[`Transition`](../../../coil.transition/-transition/index.md)`): Builder` |
