[coil-base](../../index.md) / [coil](../index.md) / [ImageLoader](./index.md)

# ImageLoader

`interface ImageLoader`

A service class that loads images by executing [ImageRequest](../../coil.request/-image-request/index.md)s. Image loaders handle caching, data fetching,
image decoding, request management, bitmap pooling, memory management, and more.

Image loaders are designed to be shareable and work best when you create a single instance and
share it throughout your app.

It's recommended, though not required, to call [shutdown](shutdown.md) when you've finished using an image loader.
This preemptively frees its memory and cleans up any observers.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |

### Properties

| Name | Summary |
|---|---|
| [bitmapPool](bitmap-pool.md) | An object pool of reusable [Bitmap](https://developer.android.com/reference/android/graphics/Bitmap.html)s.`abstract val bitmapPool: `[`BitmapPool`](../../coil.bitmap/-bitmap-pool/index.md) |
| [defaults](defaults.md) | The default options that are used to fill in unset [ImageRequest](../../coil.request/-image-request/index.md) values.`abstract val defaults: `[`DefaultRequestOptions`](../../coil.request/-default-request-options/index.md) |
| [memoryCache](memory-cache.md) | An in-memory cache of recently loaded images.`abstract val memoryCache: `[`MemoryCache`](../../coil.memory/-memory-cache/index.md) |

### Functions

| Name | Summary |
|---|---|
| [enqueue](enqueue.md) | Enqueue the [request](enqueue.md#coil.ImageLoader$enqueue(coil.request.ImageRequest)/request) to be executed asynchronously.`abstract fun enqueue(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`Disposable`](../../coil.request/-disposable/index.md) |
| [execute](execute.md) | Execute the [request](execute.md#coil.ImageLoader$execute(coil.request.ImageRequest)/request) in the current coroutine scope.`abstract suspend fun execute(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`ImageResult`](../../coil.request/-image-result/index.md) |
| [shutdown](shutdown.md) | Shutdown this image loader.`abstract fun shutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [invoke](invoke.md) | Create a new [ImageLoader](./index.md) without configuration.`operator fun invoke(context: `[`Context`](https://developer.android.com/reference/android/content/Context.html)`): `[`ImageLoader`](./index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [executeBlocking](../execute-blocking.md) | Execute the [request](../execute-blocking.md#coil$executeBlocking(coil.ImageLoader, coil.request.ImageRequest)/request) and block the current thread until it completes.`fun `[`ImageLoader`](./index.md)`.executeBlocking(request: `[`ImageRequest`](../../coil.request/-image-request/index.md)`): `[`ImageResult`](../../coil.request/-image-result/index.md) |
