/*
 * Decompiled with CFR 0.152.
 */
package coil3.video;

import android.media.MediaDataSource;
import androidx.annotation.RequiresApi;
import coil3.ImageLoader;
import coil3.decode.DataSource;
import coil3.decode.ImageSource;
import coil3.decode.ImageSourceKt;
import coil3.fetch.FetchResult;
import coil3.fetch.Fetcher;
import coil3.fetch.SourceFetchResult;
import coil3.request.Options;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import okio.Buffer;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcoil3/video/MediaDataSourceFetcher;", "Lcoil3/fetch/Fetcher;", "data", "Landroid/media/MediaDataSource;", "options", "Lcoil3/request/Options;", "<init>", "(Landroid/media/MediaDataSource;Lcoil3/request/Options;)V", "fetch", "Lcoil3/fetch/FetchResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "MediaDataSourceOkioSource", "MediaSourceMetadata", "coil-video_release"})
@RequiresApi(value=23)
public final class MediaDataSourceFetcher
implements Fetcher {
    @NotNull
    private final MediaDataSource data;
    @NotNull
    private final Options options;

    public MediaDataSourceFetcher(@NotNull MediaDataSource data, @NotNull Options options) {
        this.data = data;
        this.options = options;
    }

    @Nullable
    public Object fetch(@NotNull Continuation<? super FetchResult> $completion) {
        ImageSource imageSource = ImageSourceKt.ImageSource((BufferedSource)Okio.buffer((Source)new MediaDataSourceOkioSource(this.data)), (FileSystem)this.options.getFileSystem(), (ImageSource.Metadata)new MediaSourceMetadata(this.data));
        return new SourceFetchResult(imageSource, null, DataSource.DISK);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcoil3/video/MediaDataSourceFetcher$Factory;", "Lcoil3/fetch/Fetcher$Factory;", "Landroid/media/MediaDataSource;", "<init>", "()V", "create", "Lcoil3/fetch/Fetcher;", "data", "options", "Lcoil3/request/Options;", "imageLoader", "Lcoil3/ImageLoader;", "coil-video_release"})
    public static final class Factory
    implements Fetcher.Factory<MediaDataSource> {
        @NotNull
        public Fetcher create(@NotNull MediaDataSource data, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            return new MediaDataSourceFetcher(data, options);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcoil3/video/MediaDataSourceFetcher$MediaDataSourceOkioSource;", "Lokio/Source;", "mediaDataSource", "Landroid/media/MediaDataSource;", "<init>", "(Landroid/media/MediaDataSource;)V", "size", "", "position", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "close", "", "coil-video_release"})
    public static final class MediaDataSourceOkioSource
    implements Source {
        @NotNull
        private final MediaDataSource mediaDataSource;
        private long size;
        private long position;

        public MediaDataSourceOkioSource(@NotNull MediaDataSource mediaDataSource) {
            this.mediaDataSource = mediaDataSource;
            this.size = this.mediaDataSource.getSize();
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            if (this.position >= this.size) {
                return -1L;
            }
            long sizeToRead = Math.min(byteCount, this.size - this.position);
            byte[] byteArray = new byte[(int)sizeToRead];
            int readBytes = this.mediaDataSource.readAt(this.position, byteArray, 0, byteArray.length);
            this.position += (long)readBytes;
            sink.write(byteArray, 0, readBytes);
            return readBytes;
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
            this.mediaDataSource.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcoil3/video/MediaDataSourceFetcher$MediaSourceMetadata;", "Lcoil3/decode/ImageSource$Metadata;", "mediaDataSource", "Landroid/media/MediaDataSource;", "<init>", "(Landroid/media/MediaDataSource;)V", "getMediaDataSource", "()Landroid/media/MediaDataSource;", "coil-video_release"})
    @RequiresApi(value=23)
    public static final class MediaSourceMetadata
    extends ImageSource.Metadata {
        @NotNull
        private final MediaDataSource mediaDataSource;

        public MediaSourceMetadata(@NotNull MediaDataSource mediaDataSource) {
            this.mediaDataSource = mediaDataSource;
        }

        @NotNull
        public final MediaDataSource getMediaDataSource() {
            return this.mediaDataSource;
        }
    }
}

