/*
 * Decompiled with CFR 0.152.
 */
package coil3.video;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaDataSource;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import coil3.ImageLoader;
import coil3.Image_androidKt;
import coil3.Uri;
import coil3.Uri_androidKt;
import coil3.decode.AssetMetadata;
import coil3.decode.ContentMetadata;
import coil3.decode.DecodeResult;
import coil3.decode.DecodeUtils;
import coil3.decode.Decoder;
import coil3.decode.ImageSource;
import coil3.decode.ResourceMetadata;
import coil3.fetch.SourceFetchResult;
import coil3.request.ImageRequests_androidKt;
import coil3.request.Options;
import coil3.size.Dimension;
import coil3.size.Precision;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.size.SizeKt;
import coil3.util.IntPair;
import coil3.video.ImageRequestsKt;
import coil3.video.MediaDataSourceFetcher;
import coil3.video.internal.FileHandleMediaDataSource;
import coil3.video.internal.UtilsKt;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okio.FileHandle;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcoil3/video/VideoFrameDecoder;", "Lcoil3/decode/Decoder;", "source", "Lcoil3/decode/ImageSource;", "options", "Lcoil3/request/Options;", "<init>", "(Lcoil3/decode/ImageSource;Lcoil3/request/Options;)V", "decode", "Lcoil3/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeFrameMicros", "", "retriever", "Landroid/media/MediaMetadataRetriever;", "normalizeBitmap", "Landroid/graphics/Bitmap;", "inBitmap", "size", "Lcoil3/size/Size;", "isConfigValid", "", "bitmap", "isSizeValid", "setDataSource", "", "Factory", "coil-video_release"})
@SourceDebugExtension(value={"SMAP\nVideoFrameDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoFrameDecoder.kt\ncoil3/video/VideoFrameDecoder\n+ 2 utils.kt\ncoil3/video/internal/UtilsKt\n+ 3 collections.kt\ncoil3/util/CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BitmapDrawable.kt\nandroidx/core/graphics/drawable/BitmapDrawableKt\n+ 6 Dimension.kt\ncoil3/size/DimensionKt\n+ 7 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,273:1\n11#2,2:274\n15#2,4:281\n23#3,3:276\n1#4:279\n28#5:280\n43#6:285\n43#6:286\n43#6:291\n43#6:292\n95#7:287\n43#7,3:288\n*S KotlinDebug\n*F\n+ 1 VideoFrameDecoder.kt\ncoil3/video/VideoFrameDecoder\n*L\n52#1:274,2\n52#1:281,4\n69#1:276,3\n147#1:280\n178#1:285\n179#1:286\n211#1:291\n212#1:292\n190#1:287\n191#1:288,3\n*E\n"})
public final class VideoFrameDecoder
implements Decoder {
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;

    public VideoFrameDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this.source = source;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        DecodeResult decodeResult;
        MediaMetadataRetriever $this$use$iv = new MediaMetadataRetriever();
        boolean $i$f$use = false;
        try {
            void $this$toDrawable$iv;
            Bitmap rawBitmap;
            Bitmap bitmap;
            Bitmap it;
            Size size;
            MediaMetadataRetriever retriever = $this$use$iv;
            boolean bl = false;
            this.setDataSource(retriever, this.source);
            int srcWidth = 0;
            int srcHeight = 0;
            Object object = retriever.extractMetadata(24);
            int rotation = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            switch (rotation) {
                case 90: 
                case 270: {
                    Object object2 = retriever.extractMetadata(19);
                    srcWidth = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
                    Object object3 = retriever.extractMetadata(18);
                    srcHeight = object3 != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
                    break;
                }
                default: {
                    Object object4 = retriever.extractMetadata(18);
                    srcWidth = object4 != null && (object4 = StringsKt.toIntOrNull((String)object4)) != null ? (Integer)object4 : 0;
                    Object object5 = retriever.extractMetadata(19);
                    int n = object5 != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null ? (Integer)object5 : (srcHeight = 0);
                }
            }
            if (srcWidth > 0 && srcHeight > 0) {
                long l;
                long $this$component1_u2dwuMLFU8$iv = l = DecodeUtils.computeDstSize-sEdh43o((int)srcWidth, (int)srcHeight, (Size)this.options.getSize(), (Scale)this.options.getScale(), (Size)coil3.request.ImageRequestsKt.getMaxBitmapSize((Options)this.options));
                boolean bl2 = false;
                int dstWidth = IntPair.getFirst-impl((long)$this$component1_u2dwuMLFU8$iv);
                long $this$component2_u2dwuMLFU8$iv = l;
                boolean bl3 = false;
                int dstHeight = IntPair.getSecond-impl((long)$this$component2_u2dwuMLFU8$iv);
                double rawScale = DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)dstWidth, (int)dstHeight, (Scale)this.options.getScale());
                double scale = this.options.getPrecision() == Precision.INEXACT ? RangesKt.coerceAtMost((double)rawScale, (double)1.0) : rawScale;
                int width = MathKt.roundToInt((double)(scale * (double)srcWidth));
                int height = MathKt.roundToInt((double)(scale * (double)srcHeight));
                size = SizeKt.Size((int)width, (int)height);
            } else {
                size = Size.ORIGINAL;
            }
            Size dstSize = size;
            long frameMicros = this.computeFrameMicros(retriever);
            Dimension dstWidth = dstSize.component1();
            Dimension dstHeight = dstSize.component2();
            if (Build.VERSION.SDK_INT >= 28 && ImageRequestsKt.getVideoFrameIndex(this.options) >= 0) {
                Bitmap bl2 = UtilsKt.getFrameAtIndex(retriever, ImageRequestsKt.getVideoFrameIndex(this.options), ImageRequests_androidKt.getBitmapConfig((Options)this.options));
                if (bl2 != null) {
                    Bitmap bl3;
                    it = bl3 = bl2;
                    boolean bl4 = false;
                    srcWidth = it.getWidth();
                    srcHeight = it.getHeight();
                    bitmap = bl3;
                } else {
                    bitmap = null;
                }
            } else if (Build.VERSION.SDK_INT >= 27 && dstWidth instanceof Dimension.Pixels && dstHeight instanceof Dimension.Pixels) {
                bitmap = UtilsKt.getScaledFrameAtTime(retriever, frameMicros, ImageRequestsKt.getVideoFrameOption(this.options), ((Dimension.Pixels)dstWidth).unbox-impl(), ((Dimension.Pixels)dstHeight).unbox-impl(), ImageRequests_androidKt.getBitmapConfig((Options)this.options));
            } else {
                Bitmap bl2 = UtilsKt.getFrameAtTime(retriever, frameMicros, ImageRequestsKt.getVideoFrameOption(this.options), ImageRequests_androidKt.getBitmapConfig((Options)this.options));
                if (bl2 != null) {
                    Bitmap bl3;
                    it = bl3 = bl2;
                    boolean bl5 = false;
                    srcWidth = it.getWidth();
                    srcHeight = it.getHeight();
                    bitmap = bl3;
                } else {
                    bitmap = null;
                }
            }
            if ((rawBitmap = bitmap) == null) {
                boolean $i$a$-checkNotNull-VideoFrameDecoder$decode$2$22 = false;
                String $i$a$-checkNotNull-VideoFrameDecoder$decode$2$22 = "Failed to decode frame at " + frameMicros + " microseconds.";
                throw new IllegalStateException($i$a$-checkNotNull-VideoFrameDecoder$decode$2$22.toString());
            }
            Bitmap bitmap2 = this.normalizeBitmap(rawBitmap, dstSize);
            boolean isSampled = srcWidth > 0 && srcHeight > 0 ? DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Scale)this.options.getScale()) < 1.0 : true;
            it = bitmap2;
            Resources resources$iv = this.options.getContext().getResources();
            boolean $i$f$toDrawable = false;
            decodeResult = new DecodeResult(Image_androidKt.asImage((Drawable)((Drawable)new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv))), isSampled);
        }
        finally {
            if (Build.VERSION.SDK_INT >= 29) {
                $this$use$iv.close();
            } else {
                $this$use$iv.release();
            }
        }
        return decodeResult;
    }

    private final long computeFrameMicros(MediaMetadataRetriever retriever) {
        long frameMicros = ImageRequestsKt.getVideoFrameMicros(this.options);
        if (frameMicros >= 0L) {
            return frameMicros;
        }
        double framePercent = ImageRequestsKt.getVideoFramePercent(this.options);
        if (framePercent >= 0.0) {
            Object object = retriever.extractMetadata(9);
            long durationMillis = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
            return (long)1000 * MathKt.roundToLong((double)(framePercent * (double)durationMillis));
        }
        return 0L;
    }

    private final Bitmap normalizeBitmap(Bitmap inBitmap, Size size) {
        Canvas c$iv;
        Bitmap outBitmap;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.isConfigValid(inBitmap, this.options) && this.isSizeValid(inBitmap, this.options, size)) {
            return inBitmap;
        }
        int n6 = inBitmap.getWidth();
        int n7 = inBitmap.getHeight();
        Dimension $this$pxOrElse$iv = size.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n5 = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            n2 = inBitmap.getWidth();
            n6 = n3;
            n7 = n4;
            n5 = n2;
        }
        $this$pxOrElse$iv = size.getHeight();
        $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            n2 = n5;
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            int n8 = inBitmap.getHeight();
            n6 = n3;
            n7 = n4;
            n5 = n2;
            n = n8;
        }
        float scale = (float)DecodeUtils.computeSizeMultiplier((int)n6, (int)n7, (int)n5, (int)n, (Scale)this.options.getScale());
        int dstWidth = MathKt.roundToInt((float)(scale * (float)inBitmap.getWidth()));
        int dstHeight = MathKt.roundToInt((float)(scale * (float)inBitmap.getHeight()));
        Bitmap.Config safeConfig = Build.VERSION.SDK_INT >= 26 && ImageRequests_androidKt.getBitmapConfig((Options)this.options) == Bitmap.Config.HARDWARE ? Bitmap.Config.ARGB_8888 : ImageRequests_androidKt.getBitmapConfig((Options)this.options);
        Paint paint = new Paint(3);
        boolean $i$f$createBitmap = false;
        Bitmap $this$applyCanvas$iv = outBitmap = Bitmap.createBitmap((int)dstWidth, (int)dstHeight, (Bitmap.Config)safeConfig);
        boolean $i$f$applyCanvas = false;
        Canvas $this$normalizeBitmap_u24lambda_u246 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$normalizeBitmap_u24lambda_u246.scale(scale, scale);
        $this$normalizeBitmap_u24lambda_u246.drawBitmap(inBitmap, 0.0f, 0.0f, paint);
        inBitmap.recycle();
        return outBitmap;
    }

    private final boolean isConfigValid(Bitmap bitmap, Options options) {
        return Build.VERSION.SDK_INT < 26 || bitmap.getConfig() != Bitmap.Config.HARDWARE || ImageRequests_androidKt.getBitmapConfig((Options)options) == Bitmap.Config.HARDWARE;
    }

    private final boolean isSizeValid(Bitmap bitmap, Options options, Size size) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (options.getPrecision() == Precision.INEXACT) {
            return true;
        }
        int n6 = bitmap.getWidth();
        int n7 = bitmap.getHeight();
        Dimension $this$pxOrElse$iv = size.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n5 = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            n2 = bitmap.getWidth();
            n6 = n3;
            n7 = n4;
            n5 = n2;
        }
        $this$pxOrElse$iv = size.getHeight();
        $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            n2 = n5;
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            int n8 = bitmap.getHeight();
            n6 = n3;
            n7 = n4;
            n5 = n2;
            n = n8;
        }
        double multiplier = DecodeUtils.computeSizeMultiplier((int)n6, (int)n7, (int)n5, (int)n, (Scale)options.getScale());
        return multiplier == 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setDataSource(MediaMetadataRetriever $this$setDataSource, ImageSource source) {
        ImageSource.Metadata metadata = source.getMetadata();
        if (Build.VERSION.SDK_INT >= 23 && metadata instanceof MediaDataSourceFetcher.MediaSourceMetadata) {
            $this$setDataSource.setDataSource(((MediaDataSourceFetcher.MediaSourceMetadata)metadata).getMediaDataSource());
        } else if (metadata instanceof AssetMetadata) {
            Closeable closeable = (Closeable)this.options.getContext().getAssets().openFd(((AssetMetadata)metadata).getFilePath());
            Throwable throwable = null;
            try {
                AssetFileDescriptor it = (AssetFileDescriptor)closeable;
                boolean bl = false;
                $this$setDataSource.setDataSource(it.getFileDescriptor(), it.getStartOffset(), it.getLength());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (metadata instanceof ContentMetadata) {
            $this$setDataSource.setDataSource(this.options.getContext(), Uri_androidKt.toAndroidUri((Uri)((ContentMetadata)metadata).getUri()));
        } else if (metadata instanceof ResourceMetadata) {
            $this$setDataSource.setDataSource("android.resource://" + ((ResourceMetadata)metadata).getPackageName() + '/' + ((ResourceMetadata)metadata).getResId());
        } else if (source.getFileSystem() == FileSystem.SYSTEM) {
            $this$setDataSource.setDataSource(source.file().toFile().getPath());
        } else if (Build.VERSION.SDK_INT >= 23) {
            FileHandle handle = source.getFileSystem().openReadOnly(source.file());
            $this$setDataSource.setDataSource((MediaDataSource)new FileHandleMediaDataSource(handle));
        } else {
            throw new IllegalStateException(("Unable to read " + source.file() + " as a custom file system (" + source.getFileSystem() + ") is used and the device is API 22 or earlier.").toString());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcoil3/video/VideoFrameDecoder$Factory;", "Lcoil3/decode/Decoder$Factory;", "<init>", "()V", "create", "Lcoil3/decode/Decoder;", "result", "Lcoil3/fetch/SourceFetchResult;", "options", "Lcoil3/request/Options;", "imageLoader", "Lcoil3/ImageLoader;", "isApplicable", "", "mimeType", "", "coil-video_release"})
    public static final class Factory
    implements Decoder.Factory {
        @Nullable
        public Decoder create(@NotNull SourceFetchResult result, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(result.getMimeType())) {
                return null;
            }
            return new VideoFrameDecoder(result.getSource(), options);
        }

        private final boolean isApplicable(String mimeType) {
            return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"video/", (boolean)false, (int)2, null);
        }
    }
}

