/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.packaging;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.connect.packaging.FileSet;
import io.confluent.connect.packaging.manifest.DeliveryGuarantee;
import io.confluent.connect.packaging.manifest.DockerImage;
import io.confluent.connect.packaging.manifest.Owner;
import io.confluent.connect.packaging.manifest.PluginFeatures;
import io.confluent.connect.packaging.manifest.PluginLicense;
import io.confluent.connect.packaging.manifest.PluginMetadata;
import io.confluent.connect.packaging.manifest.PluginType;
import io.confluent.connect.packaging.manifest.Support;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="kafka-connect", defaultPhase=LifecyclePhase.PACKAGE)
public class KafkaConnectMojo
extends AbstractMojo {
    private static final List<String> expectedToplevelDocs = Arrays.asList("version.txt*", "README*", "LICENSE*", "NOTICE*");
    private static final List<String> expectedModuleDocs = Arrays.asList("licenses.html*", "licenses/", "notices/");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static List<String> excludePackages = Arrays.asList("io.confluent:kafka-connect-maven-plugin", "org.apache.kafka:connect-api", "org.apache.kafka:connect-file", "org.apache.kafka:connect-json", "org.apache.kafka:connect-runtime", "org.apache.kafka:connect-transform", "org.apache.kafka:kafka-clients");
    private final ObjectMapper mapper = new ObjectMapper();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager manager;
    @Parameter(defaultValue="2.6", readonly=true)
    private String jarPluginVersion;
    @Parameter(defaultValue="2.6", readonly=true)
    private String assemblyPluginVersion;
    @Parameter(alias="excludes", defaultValue="${excludes}", readonly=true)
    private List<String> userExcludes;
    @Parameter(alias="fileSets", readonly=true)
    private List<FileSet> userFileSets;
    public static final String EMPTY_CONFIGURATION_VALUE = "none";
    public static final String PROPERTY_PREFIX = "connect.component.";
    @Parameter(property="connect.component.attach", defaultValue="false", readonly=true)
    private String attach;
    @Parameter(property="connect.component.name", defaultValue="${project.artifactId}", required=true)
    private String name;
    @Parameter(property="connect.component.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(property="connect.component.title", defaultValue="${project.name}")
    private String title;
    @Parameter(property="connect.component.description", defaultValue="${project.description}", required=true)
    private String description;
    @Parameter(property="connect.component.logo")
    private String logo;
    @Parameter(property="connect.component.documentation.url", defaultValue="${project.url}")
    private String documentationUrl;
    @Parameter(property="connect.component.source.url", defaultValue="${project.scm.url}")
    private String sourceUrl;
    @Parameter(property="connect.component.owner.username", required=true)
    private String ownerUsername;
    @Parameter(property="connect.component.owner.type")
    private String ownerType;
    @Parameter(property="connect.component.owner.name")
    private String ownerName;
    @Parameter(property="connect.component.owner.url")
    private String ownerUrl;
    @Parameter(property="connect.component.owner.logo")
    private String ownerLogo;
    @Parameter(property="connect.component.support.providerName")
    private String supportProviderName;
    @Parameter(property="connect.component.support.summary")
    private String supportSummary;
    @Parameter(property="connect.component.support.url")
    private String supportUrl;
    @Parameter(property="connect.component.support.logo")
    private String supportLogo;
    @Parameter(property="connect.component.docker.namespace")
    private String dockerNamespace;
    @Parameter(property="connect.component.docker.name")
    private String dockerName;
    @Parameter(property="connect.component.docker.tag")
    private String dockerTag;
    @Parameter(property="connect.component.docker.registries")
    private List<String> dockerRegistries;
    @Deprecated
    @Parameter(property="connect.component.docker.label")
    private String dockerLabel;
    @Parameter
    private List<PluginLicense> licenses;
    @Parameter(property="connect.component.componentTypes", required=true)
    private Set<String> componentTypes;
    @Parameter(property="connect.component.tags")
    private Set<String> tags;
    @Parameter(property="connect.component.requirements")
    private Set<String> requirements;
    @Parameter(property="connect.component.releaseDate")
    private String releaseDate;
    @Parameter
    private Set<String> supportedEncodings;
    @Parameter(property="connect.component.features.singleMessageTransforms", defaultValue="true")
    private Boolean singleMessageTransforms;
    @Parameter(property="connect.component.features.confluentControlCenterIntegration", defaultValue="false")
    private Boolean confluentControlCenterIntegration;
    @Parameter(property="connect.component.features.kafkaConnectApi", defaultValue="true")
    private Boolean kafkaConnectApi;
    @Parameter(property="connect.component.features.deliveryGuarantee")
    private Set<String> deliveryGuarantee;

    public KafkaConnectMojo() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public void execute() throws MojoExecutionException {
        this.instantiateNullCollectionParameters();
        this.setDefaultParameters();
        this.nullifyEmptyParameters();
        this.logDeprecationWarnings();
        PluginMetadata pluginMetadata = this.constructPluginMetadata();
        this.validateManifestRequirements(pluginMetadata);
        this.collectAssets(pluginMetadata);
        this.exportManifest(pluginMetadata);
        this.requestPackageBuild();
        this.requestAssembly(this.getPluginIdentifier(pluginMetadata));
    }

    private void instantiateNullCollectionParameters() {
        if (this.userFileSets == null) {
            this.userFileSets = Collections.emptyList();
        }
        if (this.userExcludes == null) {
            this.userExcludes = Collections.emptyList();
        }
        if (this.componentTypes == null) {
            this.componentTypes = Collections.emptySet();
        }
        if (this.dockerRegistries == null) {
            this.dockerRegistries = Collections.emptyList();
        }
        if (this.tags == null) {
            this.tags = Collections.emptySet();
        }
        if (this.requirements == null) {
            this.requirements = Collections.emptySet();
        }
        if (this.deliveryGuarantee == null) {
            this.deliveryGuarantee = Collections.emptySet();
        }
        if (this.supportedEncodings == null) {
            this.supportedEncodings = Collections.singleton("any");
        }
    }

    private void setDefaultParameters() {
        if (this.licenses == null) {
            if (this.project.getLicenses() != null) {
                this.licenses = new ArrayList<PluginLicense>();
                for (License license : this.project.getLicenses()) {
                    this.licenses.add(new PluginLicense().setName(license.getName()).setUrl(license.getUrl()));
                }
            } else {
                this.licenses = Collections.emptyList();
            }
        }
        if (this.releaseDate == null) {
            this.releaseDate = DATE_FORMAT.format(System.currentTimeMillis());
        }
    }

    private void nullifyEmptyParameters() {
        this.title = this.nullifyEmptyParameter(this.title);
        this.documentationUrl = this.nullifyEmptyParameter(this.documentationUrl);
        this.sourceUrl = this.nullifyEmptyParameter(this.sourceUrl);
    }

    private String nullifyEmptyParameter(String parameter) {
        return EMPTY_CONFIGURATION_VALUE.equals(parameter) ? null : parameter;
    }

    private void logDeprecationWarnings() {
        if (this.dockerLabel != null) {
            this.getLog().warn((CharSequence)"The 'dockerLabel' property is no longer used and will be removed in a future release.");
        }
    }

    private PluginMetadata constructPluginMetadata() {
        HashSet<PluginType> parsedPluginTypes = new HashSet<PluginType>();
        for (String pluginTypeName : this.componentTypes) {
            PluginType pluginType = PluginType.parse(pluginTypeName);
            if (pluginType == null) {
                throw new IllegalArgumentException(String.format("Invalid component type: '%s'; valid values are %s", pluginTypeName, PluginType.names()));
            }
            parsedPluginTypes.add(pluginType);
        }
        HashSet<DeliveryGuarantee> parsedDeliveryGuarantees = new HashSet<DeliveryGuarantee>();
        for (String deliveryGuaranteeName : this.deliveryGuarantee) {
            DeliveryGuarantee parsedDeliveryGuarantee = DeliveryGuarantee.parseXml(deliveryGuaranteeName);
            if (parsedDeliveryGuarantee != null) continue;
            throw new IllegalArgumentException(String.format("Invalid delivery guarantee: '%s'; valid values are %s", deliveryGuaranteeName, DeliveryGuarantee.names()));
        }
        return new PluginMetadata().setName(this.name).setVersion(this.version).setTitle(this.title).setDescription(KafkaConnectMojo.trimMultiLineField(this.description)).setLogo(this.logo).setDocumentationUrl(this.documentationUrl).setSourceUrl(this.sourceUrl).setOwner(new Owner().setUsername(this.ownerUsername).setType(this.ownerType).setName(this.ownerName).setUrl(this.ownerUrl).setLogo(this.ownerLogo)).setSupport(new Support().setProviderName(this.supportProviderName).setSummary(KafkaConnectMojo.trimMultiLineField(this.supportSummary)).setUrl(this.supportUrl).setLogo(this.supportLogo)).setDockerImage(new DockerImage().setNamespace(this.dockerNamespace).setName(this.dockerName).setTag(this.dockerTag).setRegistries(this.dockerRegistries)).setLicenses(this.licenses).setPluginTypes(parsedPluginTypes).setTags(this.tags).setRequirements(this.requirements).setReleaseDate(this.releaseDate).setFeatures(new PluginFeatures().setSupportedEncodings(this.supportedEncodings).setSingleMessageTransforms(this.singleMessageTransforms).setConfluentControlCenterIntegration(this.confluentControlCenterIntegration).setKafkaConnectApi(this.kafkaConnectApi).setDeliveryGuarantee(parsedDeliveryGuarantees));
    }

    public static String trimMultiLineField(String field) {
        if (field == null) {
            return null;
        }
        String[] lines = field.trim().split("\n");
        StringBuilder result = new StringBuilder(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            result.append('\n').append(lines[i].trim());
        }
        return result.toString();
    }

    private void validateManifestRequirements(PluginMetadata pluginMetadata) throws MojoExecutionException {
        if (pluginMetadata.getOwner() == null || pluginMetadata.getOwner().getUsername() == null) {
            throw new MojoExecutionException("Component owner username must be provided");
        }
        String pluginOwnerRegex = "[a-zA-Z0-9][a-zA-Z0-9_-]*";
        String pluginOwner = pluginMetadata.getOwner().getUsername();
        if (!pluginOwner.matches(pluginOwnerRegex)) {
            throw new MojoExecutionException(String.format("Invalid component owner name: '%s'; must match regex %s", pluginOwner, pluginOwnerRegex));
        }
        if (pluginMetadata.getPluginTypes().isEmpty()) {
            throw new MojoExecutionException("At least one component type must be specified");
        }
        try {
            DATE_FORMAT.parse(this.releaseDate);
        }
        catch (ParseException e) {
            throw new MojoExecutionException(String.format("Invalid release date: '%s'; must match format %s", this.releaseDate, DATE_FORMAT.toPattern()));
        }
        if (pluginMetadata.getLicenses().isEmpty()) {
            this.getLog().warn((CharSequence)"No licenses supplied");
        }
    }

    private void exportManifest(PluginMetadata pluginMetadata) {
        String dir = this.project.getBuild().getDirectory();
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(dir + "/manifest.json"), (Object)pluginMetadata);
            this.getLog().info((CharSequence)("Writing manifest file at: " + dir + "/manifest.json"));
        }
        catch (JsonProcessingException e) {
            this.getLog().error((CharSequence)("Unable to export manifest for project: " + this.project.getArtifactId()), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to create manifest file as: " + dir + "/manifest.json"), (Throwable)e);
        }
    }

    private void requestPackageBuild() {
        try {
            String dir = this.project.getBuild().getDirectory();
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-jar-plugin"), (String)MojoExecutor.version((String)this.jarPluginVersion)), (String)MojoExecutor.goal((String)"jar"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(dir + "/components"))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.manager));
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error executing assembly", (Throwable)e);
            throw new IllegalStateException("Error executing assembly", e);
        }
    }

    private void collectAssets(PluginMetadata pluginMetadata) {
        try {
            ArrayList<MojoExecutor.Element> fileSets = new ArrayList<MojoExecutor.Element>();
            String assetPath = pluginMetadata.getLogo();
            if (this.addAssetToFileSet(assetPath, fileSets)) {
                pluginMetadata.setLogo("assets/" + KafkaConnectMojo.basename(assetPath));
            }
            String string = assetPath = pluginMetadata.getOwner() != null ? pluginMetadata.getOwner().getLogo() : null;
            if (this.addAssetToFileSet(assetPath, fileSets)) {
                pluginMetadata.getOwner().setLogo("assets/" + KafkaConnectMojo.basename(assetPath));
            }
            String string2 = assetPath = pluginMetadata.getSupport() != null ? pluginMetadata.getSupport().getLogo() : null;
            if (this.addAssetToFileSet(assetPath, fileSets)) {
                pluginMetadata.getSupport().setLogo("assets/" + KafkaConnectMojo.basename(assetPath));
            }
            for (PluginLicense license : pluginMetadata.getLicenses()) {
                assetPath = license.getLogo();
                if (!this.addAssetToFileSet(assetPath, fileSets)) continue;
                license.setLogo("assets/" + KafkaConnectMojo.basename(assetPath));
            }
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.coderplus.maven.plugins"), (String)MojoExecutor.artifactId((String)"copy-rename-maven-plugin"), (String)MojoExecutor.version((String)"1.0")), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"fileSets"), (MojoExecutor.Element[])fileSets.toArray(new MojoExecutor.Element[0]))}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.manager));
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error executing assembly", (Throwable)e);
            throw new IllegalStateException("Error executing assembly", e);
        }
    }

    private boolean addAssetToFileSet(String assetPath, Collection<MojoExecutor.Element> fileSets) throws MojoExecutionException {
        if (KafkaConnectMojo.isRelativeLink(assetPath)) {
            fileSets.add(this.assetFileSetElement(assetPath, KafkaConnectMojo.basename(assetPath)));
            return true;
        }
        if (assetPath != null) {
            throw new MojoExecutionException(String.format("Invalid logo: '%s' (must refer to a project-local file)", assetPath));
        }
        return false;
    }

    private MojoExecutor.Element assetFileSetElement(String assetPath, String assetBasename) {
        return MojoExecutor.element((String)"fileSet", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"sourceFile", (String)assetPath), MojoExecutor.element((String)"destinationFile", (String)(this.project.getBuild().getDirectory() + "/components/assets/" + assetBasename))});
    }

    private static boolean isRelativeLink(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://");
    }

    private static String basename(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private void requestAssembly(String pluginIdentifier) {
        try {
            List<String> moduleDefaults;
            MavenProject parent = this.project.getParent();
            ArrayList parentModules = new ArrayList();
            if (parent != null) {
                parentModules.addAll(parent.getModules());
            }
            Document doc = this.loadDescriptorTemplate("component-package.xml");
            NodeList fileSets = doc.getElementsByTagName("fileSets");
            Node node = fileSets.item(0);
            String directoryName = this.session.getCurrentProject().equals((Object)this.session.getTopLevelProject()) ? this.project.getBasedir().getAbsolutePath() : parent.getBasedir().getAbsolutePath();
            String outputDirectoryName = "doc/";
            List<String> toplevelDefaults = this.getDefaults(expectedToplevelDocs);
            if (!toplevelDefaults.isEmpty()) {
                node.insertBefore(this.addIncludes(doc, new FileSet(directoryName, outputDirectoryName, toplevelDefaults)), node.getLastChild());
            }
            if (!(moduleDefaults = this.getDefaults(expectedModuleDocs)).isEmpty()) {
                directoryName = this.project.getBasedir().getAbsolutePath();
                node.insertBefore(this.addIncludes(doc, new FileSet(directoryName, outputDirectoryName, moduleDefaults)), node.getLastChild());
            }
            for (FileSet userFileSet : this.userFileSets) {
                node.insertBefore(this.addIncludes(doc, userFileSet), node.getLastChild());
            }
            directoryName = this.project.getBasedir().getAbsolutePath() + "/config";
            outputDirectoryName = "etc/";
            node.insertBefore(this.addIncludes(doc, new FileSet(directoryName, outputDirectoryName, Collections.singletonList("*"))), node.getLastChild());
            directoryName = this.project.getBuild().getDirectory();
            outputDirectoryName = "/";
            node.insertBefore(this.addIncludes(doc, new FileSet(directoryName, outputDirectoryName, Collections.singletonList("manifest.json"))), node.getLastChild());
            ArrayList<String> excludePackageAll = new ArrayList<String>(excludePackages);
            excludePackageAll.addAll(this.userExcludes);
            outputDirectoryName = "lib/";
            node.getParentNode().insertBefore(this.addExcludes(doc, outputDirectoryName, excludePackageAll), node.getParentNode().getLastChild());
            directoryName = this.project.getBuild().getDirectory() + "/components/assets/";
            outputDirectoryName = "assets/";
            node.insertBefore(this.addIncludes(doc, new FileSet(directoryName, outputDirectoryName, Collections.singletonList("*"))), node.getLastChild());
            String targetDir = this.project.getBuild().getDirectory();
            this.saveDescriptor(doc, targetDir + "/components/component-package.xml");
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-assembly-plugin"), (String)MojoExecutor.version((String)this.assemblyPluginVersion)), (String)MojoExecutor.goal((String)"single"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"descriptors"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"descriptor"), (String)(targetDir + "/components/component-package.xml"))}), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(targetDir + "/components/packages")), MojoExecutor.element((String)MojoExecutor.name((String)"tarLongFileMode"), (String)"posix"), MojoExecutor.element((String)MojoExecutor.name((String)"attach"), (String)this.attach), MojoExecutor.element((String)MojoExecutor.name((String)"appendAssemblyId"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"finalName"), (String)pluginIdentifier)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.manager));
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error executing assembly", (Throwable)e);
            throw new IllegalStateException("Error executing assembly", e);
        }
    }

    private String getPluginIdentifier(PluginMetadata pluginMetadata) {
        return String.format("%s-%s-%s", pluginMetadata.getOwner().getUsername(), pluginMetadata.getName(), pluginMetadata.getVersion());
    }

    private Document loadDescriptorTemplate(String pomFilename) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setIgnoringComments(true);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream pomTemplate = loader.getResourceAsStream(pomFilename);
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            return builder.parse(pomTemplate);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IllegalStateException("Error reading assembly descriptor template " + pomFilename, e);
        }
    }

    private Node addIncludes(Document descriptor, FileSet fileSet) {
        if (fileSet.includes.isEmpty()) {
            return null;
        }
        Element fileSetNode = descriptor.createElement("fileSet");
        Element directoryNode = descriptor.createElement("directory");
        directoryNode.appendChild(descriptor.createTextNode(fileSet.directory));
        Element outputDirectoryNode = descriptor.createElement("outputDirectory");
        outputDirectoryNode.appendChild(descriptor.createTextNode(fileSet.outputDirectory));
        fileSetNode.appendChild(directoryNode);
        fileSetNode.appendChild(outputDirectoryNode);
        Element includesNode = descriptor.createElement("includes");
        for (String include : fileSet.includes) {
            Element includeNode = descriptor.createElement("include");
            includeNode.appendChild(descriptor.createTextNode(include));
            includesNode.appendChild(includeNode);
        }
        fileSetNode.appendChild(includesNode);
        return fileSetNode;
    }

    private Node addExcludes(Document descriptor, String outputDirectory, List<String> excludes) {
        Element depSetsNode = descriptor.createElement("dependencySets");
        Element depSetNode = descriptor.createElement("dependencySet");
        depSetsNode.appendChild(depSetNode);
        Element outputDirectoryNode = descriptor.createElement("outputDirectory");
        outputDirectoryNode.appendChild(descriptor.createTextNode(outputDirectory));
        depSetNode.appendChild(outputDirectoryNode);
        Element useProjectArtifactNode = descriptor.createElement("useProjectArtifact");
        useProjectArtifactNode.appendChild(descriptor.createTextNode("true"));
        depSetNode.appendChild(useProjectArtifactNode);
        Element useTransitiveFilteringNode = descriptor.createElement("useTransitiveFiltering");
        useTransitiveFilteringNode.appendChild(descriptor.createTextNode("true"));
        depSetNode.appendChild(useTransitiveFilteringNode);
        if (!excludes.isEmpty()) {
            Element excludesNode = descriptor.createElement("excludes");
            for (String exclude : excludes) {
                Element excludeNode = descriptor.createElement("exclude");
                excludeNode.appendChild(descriptor.createTextNode(exclude));
                excludesNode.appendChild(excludeNode);
            }
            depSetNode.appendChild(excludesNode);
        }
        return depSetsNode;
    }

    public List<String> getDefaults(List<String> expected) {
        ArrayList<String> defaults = new ArrayList<String>(expected);
        for (FileSet userFileSet : this.userFileSets) {
            for (String include : userFileSet.includes) {
                for (String expectedInclude : expected) {
                    if (!include.regionMatches(true, 0, expectedInclude, 0, expectedInclude.length() - 1)) continue;
                    defaults.remove(expectedInclude);
                }
            }
        }
        return defaults;
    }

    private void saveDescriptor(Document descriptor, String xmlFilename) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult result = new StreamResult(new File(xmlFilename));
            transformer.transform(new DOMSource(descriptor), result);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Error creating transformer to save maven assembly descriptor");
        }
    }
}

