/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.packaging.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OwnerType {
    ORGANIZATION("organization"),
    USER("user");

    private static final Map<String, OwnerType> TYPES_BY_NAME;
    private final String displayName;

    @JsonCreator
    public static OwnerType parse(String displayName) {
        if (displayName != null) {
            displayName = displayName.toLowerCase();
        }
        return TYPES_BY_NAME.get(displayName);
    }

    private OwnerType(String displayName) {
        this.displayName = displayName;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        TYPES_BY_NAME = new HashMap<String, OwnerType>();
        for (OwnerType type : OwnerType.values()) {
            TYPES_BY_NAME.put(type.getDisplayName().toLowerCase(), type);
        }
    }
}

