/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.packaging.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum PluginType {
    SOURCE_CONNECTOR("source"),
    SINK_CONNECTOR("sink"),
    TRANSFORM("transform"),
    CONVERTER("converter");

    private static final Map<String, PluginType> TYPES_BY_NAME;
    private final String displayName;

    public static Set<String> names() {
        return TYPES_BY_NAME.keySet();
    }

    @JsonCreator
    public static PluginType parse(String displayName) {
        if (displayName != null) {
            displayName = displayName.toLowerCase();
        }
        return TYPES_BY_NAME.get(displayName);
    }

    private PluginType(String displayName) {
        this.displayName = displayName;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        HashMap<String, PluginType> typesByName = new HashMap<String, PluginType>();
        for (PluginType type : PluginType.values()) {
            typesByName.put(type.getDisplayName().toLowerCase(), type);
        }
        TYPES_BY_NAME = Collections.unmodifiableMap(typesByName);
    }
}

