/*
 * Decompiled with CFR 0.152.
 */
package ethereum.ckzg4844;

import ethereum.ckzg4844.CellsAndProofs;
import ethereum.ckzg4844.ProofAndY;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class CKZG4844JNI {
    private static final String LIBRARY_NAME = "ckzg4844jni";
    private static final String PLATFORM_NATIVE_LIBRARY_NAME = System.mapLibraryName("ckzg4844jni");
    public static final BigInteger BLS_MODULUS = new BigInteger("52435875175126190479447740508185965837690552500527637822603658699938581184513");
    protected static final int BYTES_PER_G1 = 48;
    protected static final int BYTES_PER_G2 = 96;
    public static final int BYTES_PER_FIELD_ELEMENT = 32;
    protected static final int BITS_PER_FIELD_ELEMENT = 255;
    public static final int FIELD_ELEMENTS_PER_BLOB = 4096;
    protected static final int FIELD_ELEMENTS_PER_EXT_BLOB = 8192;
    public static final int FIELD_ELEMENTS_PER_CELL = 64;
    public static final int BYTES_PER_COMMITMENT = 48;
    public static final int BYTES_PER_PROOF = 48;
    public static final int BYTES_PER_BLOB = 131072;
    public static final int BYTES_PER_CELL = 2048;
    public static final int CELLS_PER_EXT_BLOB = 128;

    public static void loadNativeLibrary() {
        String libraryResourcePath = "lib/" + System.getProperty("os.arch") + "/" + PLATFORM_NATIVE_LIBRARY_NAME;
        InputStream libraryResource = CKZG4844JNI.class.getResourceAsStream(libraryResourcePath);
        if (libraryResource == null) {
            try {
                System.loadLibrary(LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError __) {
                String exceptionMessage = String.format("Couldn't load native library (%s). It wasn't available at %s or the library path.", LIBRARY_NAME, libraryResourcePath);
                throw new RuntimeException(exceptionMessage);
            }
        }
        try {
            Path tempDir = Files.createTempDirectory("ckzg4844jni@", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Path tempDll = tempDir.resolve(PLATFORM_NATIVE_LIBRARY_NAME);
            tempDll.toFile().deleteOnExit();
            Files.copy(libraryResource, tempDll, StandardCopyOption.REPLACE_EXISTING);
            libraryResource.close();
            System.load(tempDll.toString());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private CKZG4844JNI() {
    }

    public static native void loadTrustedSetup(String var0, long var1);

    public static native void loadTrustedSetup(byte[] var0, byte[] var1, byte[] var2, long var3);

    public static <T> void loadTrustedSetupFromResource(String resource, Class<T> clazz, long precompute) {
        InputStream is = clazz.getResourceAsStream(resource);
        if (is == null) {
            throw new IllegalArgumentException("Resource " + resource + " does not exist.");
        }
        try (InputStream inputStream = is;){
            Path jniWillLoadFrom = Files.createTempFile("kzg-trusted-setup", ".txt", new FileAttribute[0]);
            jniWillLoadFrom.toFile().deleteOnExit();
            Files.copy(is, jniWillLoadFrom, StandardCopyOption.REPLACE_EXISTING);
            CKZG4844JNI.loadTrustedSetup(jniWillLoadFrom.toString(), precompute);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Error loading trusted setup from resource " + resource, ex);
        }
    }

    public static native void freeTrustedSetup();

    public static native byte[] blobToKzgCommitment(byte[] var0);

    public static native ProofAndY computeKzgProof(byte[] var0, byte[] var1);

    public static native byte[] computeBlobKzgProof(byte[] var0, byte[] var1);

    public static native boolean verifyKzgProof(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native boolean verifyBlobKzgProof(byte[] var0, byte[] var1, byte[] var2);

    public static native boolean verifyBlobKzgProofBatch(byte[] var0, byte[] var1, byte[] var2, long var3);

    public static native CellsAndProofs computeCellsAndKzgProofs(byte[] var0);

    public static native CellsAndProofs recoverCellsAndKzgProofs(long[] var0, byte[] var1);

    public static native boolean verifyCellKzgProofBatch(byte[] var0, long[] var1, byte[] var2, byte[] var3);
}

