/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.ByteBufferWrappingBytes32;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes;
import org.apache.tuweni.bytes.MutableBytes;

class ByteBufferWrappingBytes
extends AbstractBytes {
    protected final ByteBuffer byteBuffer;
    protected final int offset;
    protected final int length;

    ByteBufferWrappingBytes(ByteBuffer byteBuffer) {
        this(byteBuffer, 0, byteBuffer.limit());
    }

    ByteBufferWrappingBytes(ByteBuffer byteBuffer, int offset, int length) {
        Checks.checkArgument(length >= 0, "Invalid negative length");
        int bufferLength = byteBuffer.capacity();
        if (bufferLength > 0) {
            Checks.checkElementIndex(offset, bufferLength);
        }
        Checks.checkArgument(offset + length <= bufferLength, "Provided length %s is too big: the value has only %s bytes from offset %s", length, bufferLength - offset, offset);
        this.byteBuffer = byteBuffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public int getInt(int i) {
        return this.byteBuffer.getInt(this.offset + i);
    }

    @Override
    public long getLong(int i) {
        return this.byteBuffer.getLong(this.offset + i);
    }

    @Override
    public byte get(int i) {
        return this.byteBuffer.get(this.offset + i);
    }

    @Override
    public Bytes slice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Checks.checkElementIndex(i, this.length);
        Checks.checkArgument(i + length <= this.length, "Provided length %s is too big: the value has size %s and has only %s bytes from %s", length, this.length, this.length - i, i);
        if (length == 32) {
            return new ByteBufferWrappingBytes32(this.byteBuffer, this.offset + i, length);
        }
        return new ByteBufferWrappingBytes(this.byteBuffer, this.offset + i, length);
    }

    @Override
    public Bytes copy() {
        if (this.offset == 0 && this.length == this.byteBuffer.limit()) {
            return this;
        }
        return new ArrayWrappingBytes(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return new MutableArrayWrappingBytes(this.toArray());
    }

    @Override
    public void appendTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.byteBuffer);
    }

    @Override
    public byte[] toArray() {
        if (!this.byteBuffer.hasArray()) {
            return super.toArray();
        }
        int arrayOffset = this.byteBuffer.arrayOffset();
        return Arrays.copyOfRange(this.byteBuffer.array(), arrayOffset + this.offset, arrayOffset + this.offset + this.length);
    }

    @Override
    public byte[] toArrayUnsafe() {
        if (!this.byteBuffer.hasArray()) {
            return this.toArray();
        }
        byte[] array = this.byteBuffer.array();
        if (array.length != this.length || this.byteBuffer.arrayOffset() != 0) {
            return this.toArray();
        }
        return array;
    }
}

