/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.identityconnectors.common.security.GuardedByteArray;

class GuardedByteArrayBytes
extends AbstractBytes {
    protected final GuardedByteArray bytes;
    protected final int offset;
    protected final int length;

    GuardedByteArrayBytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    GuardedByteArrayBytes(byte[] bytes, int offset, int length) {
        Checks.checkArgument(length >= 0, "Invalid negative length");
        if (bytes.length > 0) {
            Checks.checkElementIndex(offset, bytes.length);
        }
        Checks.checkArgument(offset + length <= bytes.length, "Provided length %s is too big: the value has only %s bytes from offset %s", length, bytes.length - offset, offset);
        this.bytes = new GuardedByteArray(bytes);
        this.bytes.makeReadOnly();
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public byte get(int i) {
        Checks.checkElementIndex(i, this.size());
        AtomicReference b = new AtomicReference();
        this.bytes.access(bytes -> b.set(bytes[this.offset + i]));
        return (Byte)b.get();
    }

    @Override
    public Bytes slice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Checks.checkElementIndex(i, this.length);
        Checks.checkArgument(i + length <= this.length, "Provided length %s is too big: the value has size %s and has only %s bytes from %s", length, this.length, this.length - i, i);
        AtomicReference clearBytes = new AtomicReference();
        this.bytes.access(data -> {
            byte[] result = new byte[length];
            System.arraycopy(data, this.offset + i, result, 0, length);
            clearBytes.set(result);
        });
        return length == 32 ? new ArrayWrappingBytes32((byte[])clearBytes.get()) : new ArrayWrappingBytes((byte[])clearBytes.get(), 0, length);
    }

    @Override
    public Bytes copy() {
        return new ArrayWrappingBytes(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return new MutableArrayWrappingBytes(this.toArray());
    }

    @Override
    public void update(MessageDigest digest) {
        digest.update(this.toArray(), this.offset, this.length);
    }

    @Override
    public void copyTo(MutableBytes destination, int destinationOffset) {
        if (!(destination instanceof MutableArrayWrappingBytes)) {
            super.copyTo(destination, destinationOffset);
            return;
        }
        int size = this.size();
        if (size == 0) {
            return;
        }
        Checks.checkElementIndex(destinationOffset, destination.size());
        Checks.checkArgument(destination.size() - destinationOffset >= size, "Cannot copy %s bytes, destination has only %s bytes from index %s", size, destination.size() - destinationOffset, destinationOffset);
        MutableArrayWrappingBytes d = (MutableArrayWrappingBytes)destination;
        System.arraycopy(this.toArray(), this.offset, d.bytes, d.offset + destinationOffset, size);
    }

    @Override
    public void appendTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.toArray(), this.offset, this.length);
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBytes(this.toArray(), this.offset, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GuardedByteArrayBytes)) {
            return super.equals(obj);
        }
        GuardedByteArrayBytes other = (GuardedByteArrayBytes)obj;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.get(this.offset + i) == other.get(other.offset + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result = 31 * result + this.get(this.offset + i);
        }
        return result;
    }

    @Override
    public byte[] toArray() {
        AtomicReference clearBytes = new AtomicReference();
        this.bytes.access(data -> {
            byte[] result = new byte[this.length];
            System.arraycopy(data, this.offset, result, 0, this.length);
            clearBytes.set(result);
        });
        return (byte[])clearBytes.get();
    }

    @Override
    public byte[] toArrayUnsafe() {
        return this.toArray();
    }
}

