/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;

public final class ExpiringSet<E>
implements Set<E> {
    private final Consumer<E> globalExpiryListener;
    private final ConcurrentHashMap<E, ExpiringEntry<E>> storage = new ConcurrentHashMap();
    private final PriorityBlockingQueue<ExpiringEntry<E>> expiryQueue = new PriorityBlockingQueue();
    private final LongSupplier currentTimeSupplier;
    private final long evictionTimeout;

    public ExpiringSet(long evictionTimeout) {
        this(evictionTimeout, System::currentTimeMillis, null);
    }

    public ExpiringSet(long evictionTimeout, Consumer<E> expiryListener) {
        this(evictionTimeout, System::currentTimeMillis, expiryListener);
    }

    public ExpiringSet() {
        this(Long.MAX_VALUE, System::currentTimeMillis, null);
    }

    ExpiringSet(long evictionTimeout, LongSupplier currentTimeSupplier, Consumer<E> expiryListener) {
        if (evictionTimeout <= 0L) {
            throw new IllegalArgumentException("Invalid eviction timeout " + evictionTimeout);
        }
        this.evictionTimeout = evictionTimeout;
        this.currentTimeSupplier = currentTimeSupplier;
        this.globalExpiryListener = expiryListener;
    }

    @Override
    public boolean contains(Object element) {
        this.purgeExpired();
        return this.storage.containsKey(element);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.purgeExpired();
        for (Object element : c) {
            if (this.storage.containsKey(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        this.purgeExpired();
        return this.storage.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeExpired();
        return this.storage.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.purgeExpired();
        return ((ConcurrentHashMap.KeySetView)this.storage.keySet()).iterator();
    }

    @Override
    public Object[] toArray() {
        this.purgeExpired();
        return ((ConcurrentHashMap.CollectionView)((Object)this.storage.keySet())).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Objects.requireNonNull(a);
        this.purgeExpired();
        return ((ConcurrentHashMap.CollectionView)((Object)this.storage.keySet())).toArray(a);
    }

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        this.purgeExpired();
        ExpiringEntry<E> oldEntry = this.storage.put(e, new ExpiringEntry<E>(e, this.currentTimeSupplier.getAsLong() + this.evictionTimeout, this.globalExpiryListener));
        return oldEntry == null;
    }

    public boolean add(E element, long expiry) {
        return this.add(element, expiry, this.globalExpiryListener);
    }

    public boolean add(E element, long expiry, @Nullable Consumer<E> expiryListener) {
        Objects.requireNonNull(element);
        long now = this.currentTimeSupplier.getAsLong();
        this.purgeExpired(now);
        if (expiry <= now) {
            boolean removedPrevious = this.remove(element);
            if (expiryListener != null) {
                expiryListener.accept(element);
            }
            return removedPrevious;
        }
        ExpiringEntry<E> newEntry = new ExpiringEntry<E>(element, expiry, expiryListener == null ? this.globalExpiryListener : expiryListener);
        ExpiringEntry<E> oldEntry = this.storage.put(element, newEntry);
        this.expiryQueue.offer(newEntry);
        if (oldEntry != null && oldEntry.expiry < Long.MAX_VALUE) {
            this.expiryQueue.remove(oldEntry);
        }
        return oldEntry == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Objects.requireNonNull(c);
        this.purgeExpired();
        boolean noOldElements = true;
        for (E element : c) {
            ExpiringEntry<E> oldEntry = this.storage.put(element, new ExpiringEntry<E>(element, Long.MAX_VALUE, this.globalExpiryListener));
            if (oldEntry == null) continue;
            noOldElements = false;
        }
        return noOldElements;
    }

    @Override
    public boolean remove(Object element) {
        Objects.requireNonNull(element);
        this.purgeExpired();
        ExpiringEntry<E> entry = this.storage.remove(element);
        if (entry == null) {
            return false;
        }
        if (entry.expiry < Long.MAX_VALUE) {
            this.expiryQueue.remove(entry);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        this.purgeExpired();
        boolean changed = false;
        for (Object element : c) {
            ExpiringEntry<E> entry = this.storage.remove(element);
            if (entry == null) continue;
            if (entry.expiry < Long.MAX_VALUE) {
                this.expiryQueue.remove(entry);
            }
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.expiryQueue.clear();
        this.storage.clear();
    }

    public long purgeExpired() {
        return this.purgeExpired(this.currentTimeSupplier.getAsLong());
    }

    private long purgeExpired(long oldest) {
        ExpiringEntry<E> entry;
        while ((entry = this.expiryQueue.peek()) != null && entry.expiry <= oldest) {
            if (!this.expiryQueue.remove(entry) || !this.storage.remove(entry.element, entry) || entry.expiryListener == null) continue;
            entry.expiryListener.accept(entry.element);
        }
        return entry == null ? Long.MAX_VALUE : entry.expiry;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExpiringSet)) {
            return false;
        }
        ExpiringSet other = (ExpiringSet)obj;
        return this.storage.equals(other.storage);
    }

    @Override
    public int hashCode() {
        return this.storage.hashCode();
    }

    private static final class ExpiringEntry<E>
    implements Comparable<ExpiringEntry<E>> {
        private E element;
        private long expiry;
        @Nullable
        private Consumer<E> expiryListener;

        ExpiringEntry(E element, long expiry, @Nullable Consumer<E> expiryListener) {
            this.element = element;
            this.expiry = expiry;
            this.expiryListener = expiryListener;
        }

        @Override
        public int compareTo(ExpiringEntry<E> o) {
            return Long.compare(this.expiry, o.expiry);
        }
    }
}

