/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Sodium;
import org.jetbrains.annotations.Nullable;

public final class Allocated
implements Destroyable {
    @Nullable
    private Pointer ptr;
    private final int length;

    public static Allocated fromBytes(Bytes bytes) {
        Allocated allocated = Allocated.allocate(bytes.size());
        allocated.pointer().put(0L, bytes.toArrayUnsafe(), 0, bytes.size());
        return allocated;
    }

    static Allocated allocate(long length) {
        Pointer ptr = Sodium.malloc(length);
        return new Allocated(ptr, (int)length);
    }

    Allocated(Pointer ptr, int length) {
        this.ptr = ptr;
        this.length = length;
    }

    Pointer pointer() {
        if (this.isDestroyed()) {
            throw new IllegalArgumentException("SecretKey has been destroyed");
        }
        return this.ptr;
    }

    int length() {
        return this.length;
    }

    @Override
    public void destroy() {
        if (!this.isDestroyed()) {
            Pointer p = this.ptr;
            this.ptr = null;
            Sodium.sodium_free(p);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.ptr == null;
    }

    public Bytes bytes() {
        return Bytes.wrap((byte[])this.bytesArray());
    }

    public byte[] bytesArray() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("allocated value has been destroyed");
        }
        return Sodium.reify(this.ptr, this.length);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Allocated)) {
            return false;
        }
        Allocated other = (Allocated)obj;
        if (this.isDestroyed()) {
            throw new IllegalStateException("allocated value has been destroyed");
        }
        if (other.isDestroyed()) {
            throw new IllegalStateException("allocated value has been destroyed");
        }
        return Sodium.sodium_memcmp(this.ptr, other.ptr, this.length) == 0;
    }

    public int hashCode() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("allocated value has been destroyed");
        }
        return Sodium.hashCode(this.ptr, this.length);
    }
}

