/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import jnr.ffi.byref.ByteByReference;
import jnr.ffi.byref.LongLongByReference;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.DefaultDetachedEncryptionResult;
import org.apache.tuweni.crypto.sodium.DetachedEncryptionResult;
import org.apache.tuweni.crypto.sodium.SecretDecryptionStream;
import org.apache.tuweni.crypto.sodium.SecretEncryptionStream;
import org.apache.tuweni.crypto.sodium.Sodium;
import org.apache.tuweni.crypto.sodium.SodiumException;
import org.jetbrains.annotations.Nullable;

public final class XChaCha20Poly1305 {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte TAG_FINAL = 3;

    private XChaCha20Poly1305() {
    }

    public static boolean isAvailable() {
        try {
            return Sodium.supportsVersion(Sodium.VERSION_10_0_12);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static void assertAvailable() {
        if (!XChaCha20Poly1305.isAvailable()) {
            throw new UnsupportedOperationException("Sodium XChaCha20Poly1305 is not available (requires sodium native library >= 10.0.12)");
        }
    }

    public static boolean isSecretStreamAvailable() {
        try {
            return Sodium.supportsVersion(Sodium.VERSION_10_0_14);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static void assertSecretStreamAvailable() {
        if (!XChaCha20Poly1305.isSecretStreamAvailable()) {
            throw new UnsupportedOperationException("Sodium XChaCha20Poly1305 secret stream is not available (requires sodium native library >= 10.0.14)");
        }
    }

    public static Bytes encrypt(Bytes message, Key key, Nonce nonce) {
        return Bytes.wrap((byte[])XChaCha20Poly1305.encrypt(message.toArrayUnsafe(), key, nonce));
    }

    public static byte[] encrypt(byte[] message, Key key, Nonce nonce) {
        return XChaCha20Poly1305.encrypt(message, EMPTY_BYTES, key, nonce);
    }

    public static Bytes encrypt(Bytes message, Bytes data, Key key, Nonce nonce) {
        return Bytes.wrap((byte[])XChaCha20Poly1305.encrypt(message.toArrayUnsafe(), data.toArrayUnsafe(), key, nonce));
    }

    public static byte[] encrypt(byte[] message, byte[] data, Key key, Nonce nonce) {
        LongLongByReference cipherTextLen;
        XChaCha20Poly1305.assertAvailable();
        if (key.isDestroyed()) {
            throw new IllegalArgumentException("Key has been destroyed");
        }
        byte[] cipherText = new byte[XChaCha20Poly1305.maxCypherTextLength(message)];
        int rc = Sodium.crypto_aead_xchacha20poly1305_ietf_encrypt(cipherText, cipherTextLen = new LongLongByReference(), message, message.length, data, data.length, null, nonce.value.pointer(), key.value.pointer());
        if (rc != 0) {
            throw new SodiumException("crypto_aead_xchacha20poly1305_ietf_encrypt: failed with result " + rc);
        }
        return XChaCha20Poly1305.maybeSliceResult(cipherText, cipherTextLen, "crypto_aead_xchacha20poly1305_ietf_encrypt");
    }

    private static int maxCypherTextLength(byte[] message) {
        long abytes = Sodium.crypto_aead_xchacha20poly1305_ietf_abytes();
        if (abytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("crypto_aead_xchacha20poly1305_ietf_abytes: " + abytes + " is too large");
        }
        return (int)abytes + message.length;
    }

    public static DetachedEncryptionResult encryptDetached(Bytes message, Key key, Nonce nonce) {
        return XChaCha20Poly1305.encryptDetached(message.toArrayUnsafe(), key, nonce);
    }

    public static DetachedEncryptionResult encryptDetached(byte[] message, Key key, Nonce nonce) {
        return XChaCha20Poly1305.encryptDetached(message, EMPTY_BYTES, key, nonce);
    }

    public static DetachedEncryptionResult encryptDetached(Bytes message, Bytes data, Key key, Nonce nonce) {
        return XChaCha20Poly1305.encryptDetached(message.toArrayUnsafe(), data.toArrayUnsafe(), key, nonce);
    }

    public static DetachedEncryptionResult encryptDetached(byte[] message, byte[] data, Key key, Nonce nonce) {
        XChaCha20Poly1305.assertAvailable();
        if (key.isDestroyed()) {
            throw new IllegalArgumentException("Key has been destroyed");
        }
        byte[] cipherText = new byte[message.length];
        long abytes = Sodium.crypto_aead_xchacha20poly1305_ietf_abytes();
        if (abytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("crypto_aead_xchacha20poly1305_ietf_abytes: " + abytes + " is too large");
        }
        byte[] mac = new byte[(int)abytes];
        LongLongByReference macLen = new LongLongByReference();
        int rc = Sodium.crypto_aead_xchacha20poly1305_ietf_encrypt_detached(cipherText, mac, macLen, message, message.length, data, data.length, null, nonce.value.pointer(), key.value.pointer());
        if (rc != 0) {
            throw new SodiumException("crypto_aead_xchacha20poly1305_ietf_encrypt_detached: failed with result " + rc);
        }
        return new DefaultDetachedEncryptionResult(cipherText, XChaCha20Poly1305.maybeSliceResult(mac, macLen, "crypto_aead_xchacha20poly1305_ietf_encrypt_detached"));
    }

    public static SecretEncryptionStream openEncryptionStream(Key key) {
        XChaCha20Poly1305.assertSecretStreamAvailable();
        return new SSEncrypt(key);
    }

    @Nullable
    public static Bytes decrypt(Bytes cipherText, Key key, Nonce nonce) {
        byte[] bytes = XChaCha20Poly1305.decrypt(cipherText.toArrayUnsafe(), key, nonce);
        return bytes != null ? Bytes.wrap((byte[])bytes) : null;
    }

    @Nullable
    public static byte[] decrypt(byte[] cipherText, Key key, Nonce nonce) {
        return XChaCha20Poly1305.decrypt(cipherText, EMPTY_BYTES, key, nonce);
    }

    @Nullable
    public static Bytes decrypt(Bytes cipherText, Bytes data, Key key, Nonce nonce) {
        byte[] bytes = XChaCha20Poly1305.decrypt(cipherText.toArrayUnsafe(), data.toArrayUnsafe(), key, nonce);
        return bytes != null ? Bytes.wrap((byte[])bytes) : null;
    }

    @Nullable
    public static byte[] decrypt(byte[] cipherText, byte[] data, Key key, Nonce nonce) {
        LongLongByReference clearTextLen;
        XChaCha20Poly1305.assertAvailable();
        if (key.isDestroyed()) {
            throw new IllegalArgumentException("Key has been destroyed");
        }
        byte[] clearText = new byte[XChaCha20Poly1305.maxClearTextLength(cipherText)];
        int rc = Sodium.crypto_aead_xchacha20poly1305_ietf_decrypt(clearText, clearTextLen = new LongLongByReference(), null, cipherText, cipherText.length, data, data.length, nonce.value.pointer(), key.value.pointer());
        if (rc == -1) {
            return null;
        }
        if (rc != 0) {
            throw new SodiumException("crypto_aead_xchacha20poly1305_ietf_decrypt: failed with result " + rc);
        }
        return XChaCha20Poly1305.maybeSliceResult(clearText, clearTextLen, "crypto_aead_xchacha20poly1305_ietf_decrypt");
    }

    private static int maxClearTextLength(byte[] cipherText) {
        long abytes = Sodium.crypto_aead_xchacha20poly1305_ietf_abytes();
        if (abytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("crypto_aead_xchacha20poly1305_ietf_abytes: " + abytes + " is too large");
        }
        if (abytes > (long)cipherText.length) {
            throw new IllegalArgumentException("cipherText is too short");
        }
        return cipherText.length - (int)abytes;
    }

    public static Bytes decryptDetached(Bytes cipherText, Bytes mac, Key key, Nonce nonce) {
        byte[] bytes = XChaCha20Poly1305.decryptDetached(cipherText.toArrayUnsafe(), mac.toArrayUnsafe(), key, nonce);
        return bytes != null ? Bytes.wrap((byte[])bytes) : null;
    }

    @Nullable
    public static byte[] decryptDetached(byte[] cipherText, byte[] mac, Key key, Nonce nonce) {
        return XChaCha20Poly1305.decryptDetached(cipherText, mac, EMPTY_BYTES, key, nonce);
    }

    @Nullable
    public static Bytes decryptDetached(Bytes cipherText, Bytes mac, Bytes data, Key key, Nonce nonce) {
        byte[] bytes = XChaCha20Poly1305.decryptDetached(cipherText.toArrayUnsafe(), mac.toArrayUnsafe(), data.toArrayUnsafe(), key, nonce);
        return bytes != null ? Bytes.wrap((byte[])bytes) : null;
    }

    @Nullable
    public static byte[] decryptDetached(byte[] cipherText, byte[] mac, byte[] data, Key key, Nonce nonce) {
        XChaCha20Poly1305.assertAvailable();
        if (key.isDestroyed()) {
            throw new IllegalArgumentException("Key has been destroyed");
        }
        long abytes = Sodium.crypto_aead_xchacha20poly1305_ietf_abytes();
        if (abytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("crypto_aead_xchacha20poly1305_ietf_abytes: " + abytes + " is too large");
        }
        if ((long)mac.length != abytes) {
            throw new IllegalArgumentException("mac must be " + abytes + " bytes, got " + mac.length);
        }
        byte[] clearText = new byte[cipherText.length];
        int rc = Sodium.crypto_aead_xchacha20poly1305_ietf_decrypt_detached(clearText, null, cipherText, cipherText.length, mac, data, data.length, nonce.value.pointer(), key.value.pointer());
        if (rc == -1) {
            return null;
        }
        if (rc != 0) {
            throw new SodiumException("crypto_aead_xchacha20poly1305_ietf_decrypt_detached: failed with result " + rc);
        }
        return clearText;
    }

    public static SecretDecryptionStream openDecryptionStream(Key key, byte[] header) {
        XChaCha20Poly1305.assertSecretStreamAvailable();
        return new SSDecrypt(key, header);
    }

    private static byte[] maybeSliceResult(byte[] bytes, LongLongByReference actualLength, String methodName) {
        if (actualLength.longValue() == (long)bytes.length) {
            return bytes;
        }
        if (actualLength.longValue() > Integer.MAX_VALUE) {
            throw new SodiumException(methodName + ": result of length " + actualLength.longValue() + " is too large");
        }
        byte[] result = new byte[actualLength.intValue()];
        System.arraycopy(bytes, 0, result, 0, result.length);
        return result;
    }

    public static final class Key
    implements Destroyable {
        final Allocated value;

        private Key(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public static Key fromBytes(Bytes bytes) {
            return Key.fromBytes(bytes.toArrayUnsafe());
        }

        public static Key fromBytes(byte[] bytes) {
            XChaCha20Poly1305.assertAvailable();
            if ((long)bytes.length != Sodium.crypto_aead_xchacha20poly1305_ietf_keybytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_aead_xchacha20poly1305_ietf_keybytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, Key::new);
        }

        public static int length() {
            XChaCha20Poly1305.assertAvailable();
            long keybytes = Sodium.crypto_aead_xchacha20poly1305_ietf_keybytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_aead_xchacha20poly1305_ietf_keybytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public static Key random() {
            XChaCha20Poly1305.assertAvailable();
            int length = Key.length();
            Pointer ptr = Sodium.malloc(length);
            try {
                Sodium.randombytes_buf(ptr, length);
                return new Key(ptr, length);
            }
            catch (Throwable e) {
                Sodium.sodium_free(ptr);
                throw e;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }

    public static final class Nonce {
        final Allocated value;

        private Nonce(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        public static Nonce fromBytes(Bytes bytes) {
            return Nonce.fromBytes(bytes.toArrayUnsafe());
        }

        public static Nonce fromBytes(byte[] bytes) {
            XChaCha20Poly1305.assertAvailable();
            if ((long)bytes.length != Sodium.crypto_aead_xchacha20poly1305_ietf_npubbytes()) {
                throw new IllegalArgumentException("nonce must be " + Sodium.crypto_aead_xchacha20poly1305_ietf_npubbytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, Nonce::new);
        }

        public static int length() {
            XChaCha20Poly1305.assertAvailable();
            long npubbytes = Sodium.crypto_aead_xchacha20poly1305_ietf_npubbytes();
            if (npubbytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_aead_xchacha20poly1305_ietf_npubbytes: " + npubbytes + " is too large");
            }
            return (int)npubbytes;
        }

        public static Nonce zero() {
            int length = Nonce.length();
            Pointer ptr = Sodium.malloc(length);
            try {
                Sodium.sodium_memzero(ptr, length);
                return new Nonce(ptr, length);
            }
            catch (Throwable e) {
                Sodium.sodium_free(ptr);
                throw e;
            }
        }

        public static Nonce random() {
            XChaCha20Poly1305.assertAvailable();
            return Sodium.randomBytes(Nonce.length(), Nonce::new);
        }

        public Nonce increment() {
            return Sodium.dupAndIncrement(this.value.pointer(), this.value.length(), Nonce::new);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Nonce)) {
                return false;
            }
            Nonce other = (Nonce)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }

    private static final class SSEncrypt
    implements SecretEncryptionStream {
        private final int abytes;
        private final byte[] header;
        @Nullable
        private Pointer state;
        private boolean complete = false;

        private SSEncrypt(Key key) {
            if (key.isDestroyed()) {
                throw new IllegalArgumentException("Key has been destroyed");
            }
            long abytes = Sodium.crypto_secretstream_xchacha20poly1305_abytes();
            if (abytes > Integer.MAX_VALUE) {
                throw new IllegalStateException("crypto_aead_xchacha20poly1305_ietf_abytes: " + abytes + " is too large");
            }
            this.abytes = (int)abytes;
            long headerbytes = Sodium.crypto_secretstream_xchacha20poly1305_headerbytes();
            if (headerbytes > Integer.MAX_VALUE) {
                throw new IllegalStateException("crypto_secretstream_xchacha20poly1305_headerbytes: " + abytes + " is too large");
            }
            this.header = new byte[(int)headerbytes];
            Pointer state = Sodium.malloc(Sodium.crypto_secretstream_xchacha20poly1305_statebytes());
            try {
                int rc = Sodium.crypto_secretstream_xchacha20poly1305_init_push(state, this.header, key.value.pointer());
                if (rc != 0) {
                    throw new SodiumException("crypto_secretstream_xchacha20poly1305_init_push: failed with result " + rc);
                }
            }
            catch (Throwable e) {
                Sodium.sodium_free(state);
                throw e;
            }
            this.state = state;
        }

        @Override
        public void destroy() {
            if (this.state != null) {
                Pointer p = this.state;
                this.state = null;
                Sodium.sodium_free(p);
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.state == null;
        }

        @Override
        public byte[] headerArray() {
            return this.header;
        }

        @Override
        public byte[] push(byte[] clearText, boolean isFinal) {
            if (this.complete) {
                throw new IllegalStateException("stream already completed");
            }
            if (this.state == null) {
                throw new IllegalStateException("stream has been destroyed");
            }
            byte[] cipherText = new byte[this.abytes + clearText.length];
            byte tag = isFinal ? (byte)3 : 0;
            int rc = Sodium.crypto_secretstream_xchacha20poly1305_push(this.state, cipherText, null, clearText, clearText.length, null, 0L, tag);
            if (rc != 0) {
                throw new SodiumException("crypto_secretstream_xchacha20poly1305_push: failed with result " + rc);
            }
            if (isFinal) {
                this.complete = true;
                this.destroy();
            }
            return cipherText;
        }
    }

    private static final class SSDecrypt
    implements SecretDecryptionStream {
        private final int abytes;
        @Nullable
        private Pointer state;
        private boolean complete = false;

        private SSDecrypt(Key key, byte[] header) {
            if (key.isDestroyed()) {
                throw new IllegalArgumentException("Key has been destroyed");
            }
            if ((long)header.length != Sodium.crypto_secretstream_xchacha20poly1305_headerbytes()) {
                throw new IllegalArgumentException("header must be " + Sodium.crypto_secretstream_xchacha20poly1305_headerbytes() + " bytes, got " + header.length);
            }
            long abytes = Sodium.crypto_secretstream_xchacha20poly1305_abytes();
            if (abytes > Integer.MAX_VALUE) {
                throw new IllegalStateException("crypto_aead_xchacha20poly1305_ietf_abytes: " + abytes + " is too large");
            }
            this.abytes = (int)abytes;
            Pointer state = Sodium.malloc(Sodium.crypto_secretstream_xchacha20poly1305_statebytes());
            try {
                int rc = Sodium.crypto_secretstream_xchacha20poly1305_init_pull(state, header, key.value.pointer());
                if (rc != 0) {
                    throw new SodiumException("crypto_secretstream_xchacha20poly1305_init_push: failed with result " + rc);
                }
            }
            catch (Throwable e) {
                Sodium.sodium_free(state);
                throw e;
            }
            this.state = state;
        }

        @Override
        public void destroy() {
            if (this.state != null) {
                Pointer p = this.state;
                this.state = null;
                Sodium.sodium_free(p);
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.state == null;
        }

        @Override
        public byte[] pull(byte[] cipherText) {
            if (this.complete) {
                throw new IllegalStateException("stream already completed");
            }
            if (this.state == null) {
                throw new IllegalStateException("stream has been destroyed");
            }
            if (this.abytes > cipherText.length) {
                throw new IllegalArgumentException("cipherText is too short");
            }
            byte[] clearText = new byte[cipherText.length - this.abytes];
            ByteByReference tag = new ByteByReference();
            int rc = Sodium.crypto_secretstream_xchacha20poly1305_pull(this.state, clearText, null, tag, cipherText, cipherText.length, null, 0L);
            if (rc != 0) {
                throw new SodiumException("crypto_secretstream_xchacha20poly1305_push: failed with result " + rc);
            }
            if (tag.byteValue() == 3) {
                this.complete = true;
                this.destroy();
            }
            return clearText;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }
}

