/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.nio.ByteOrder;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt32Value;

public final class UInt32
implements UInt32Value<UInt32> {
    private static final int MAX_CONSTANT = 255;
    private static UInt32[] CONSTANTS = new UInt32[256];
    public static final UInt32 MIN_VALUE;
    public static final UInt32 MAX_VALUE;
    public static final UInt32 ZERO;
    public static final UInt32 ONE;
    private static final BigInteger P_2_32;
    private final Bytes value;

    public static UInt32 valueOf(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        return UInt32.create(value);
    }

    public static UInt32 valueOf(BigInteger value) {
        if (value.bitLength() > 32) {
            throw new IllegalArgumentException("Argument is too large to represent a UInt32");
        }
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        return UInt32.create(value.toByteArray());
    }

    public static UInt32 fromBytes(Bytes bytes) {
        return UInt32.fromBytes(bytes, ByteOrder.BIG_ENDIAN);
    }

    public static UInt32 fromBytes(Bytes bytes, ByteOrder byteOrder) {
        if (bytes.size() > 4) {
            throw new IllegalArgumentException("Argument is greater than 4 bytes");
        }
        return UInt32.create(byteOrder == ByteOrder.LITTLE_ENDIAN ? bytes.reverse() : bytes);
    }

    public static UInt32 fromHexString(String str) {
        return UInt32.fromBytes(Bytes.fromHexStringLenient((CharSequence)str));
    }

    private static UInt32 create(Bytes value) {
        return UInt32.create(value.toArrayUnsafe());
    }

    private static UInt32 create(byte[] value) {
        if (value.length == 4 && value[0] == 0 && value[1] == 0 && value[2] == 0) {
            return CONSTANTS[value[3] & 0xFF];
        }
        if (value.length == 3) {
            value = new byte[]{0, value[0], value[1], value[2]};
        } else if (value.length == 2) {
            value = new byte[]{0, 0, value[0], value[1]};
        } else if (value.length == 1) {
            value = new byte[]{0, 0, 0, value[0]};
        } else if (value.length == 0) {
            value = new byte[4];
        }
        return new UInt32(value);
    }

    private static UInt32 create(int value) {
        if (value >= 0 && value <= 255) {
            return CONSTANTS[value];
        }
        return new UInt32(new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)});
    }

    private UInt32(byte[] bytes) {
        this.value = Bytes.wrap((byte[])bytes);
    }

    @Override
    public boolean isZero() {
        return ZERO.equals(this);
    }

    @Override
    public UInt32 add(UInt32 value) {
        if (value.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return value;
        }
        byte[] result = new byte[4];
        int carry = 0;
        for (int i = 3; i >= 0; --i) {
            int sum = (this.value.get(i) & 0xFF) + (value.value.get(i) & 0xFF) + carry;
            result[i] = (byte)sum;
            carry = sum >>> 8;
        }
        return UInt32.create(result);
    }

    @Override
    public UInt32 add(int value) {
        if (value == 0) {
            return this;
        }
        return UInt32.create(this.value.toInt() + value);
    }

    @Override
    public UInt32 addMod(UInt32 value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        return UInt32.create(this.toBigInteger().add(value.toBigInteger()).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 addMod(long value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        return UInt32.create(this.toBigInteger().add(BigInteger.valueOf(value)).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 addMod(long value, long modulus) {
        if (modulus == 0L) {
            throw new ArithmeticException("addMod with zero modulus");
        }
        if (modulus < 0L) {
            throw new ArithmeticException("addMod unsigned with negative modulus");
        }
        return UInt32.create(this.toBigInteger().add(BigInteger.valueOf(value)).mod(BigInteger.valueOf(modulus)).intValue());
    }

    @Override
    public UInt32 subtract(UInt32 value) {
        if (value.isZero()) {
            return this;
        }
        byte[] result = new byte[4];
        int borrow = 0;
        for (int i = 3; 0 <= i; --i) {
            int i1 = this.value.get(i) & 0xFF;
            int i2 = value.value.get(i) & 0xFF;
            int col = i1 - i2 + borrow;
            borrow = col >> 8;
            result[i] = (byte)(col & 0xFF);
        }
        return UInt32.create(result);
    }

    @Override
    public UInt32 subtract(int value) {
        return this.subtract(UInt32.create(value));
    }

    @Override
    public UInt32 multiply(UInt32 value) {
        return UInt32.create(this.value.toInt() * value.value.toInt());
    }

    @Override
    public UInt32 multiply(int value) {
        if (value < 0) {
            throw new ArithmeticException("multiply unsigned by negative");
        }
        if (value == 0 || this.isZero()) {
            return ZERO;
        }
        if (value == 1) {
            return this;
        }
        return this.multiply(UInt32.valueOf(value));
    }

    @Override
    public UInt32 multiplyMod(UInt32 value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (this.isZero() || value.isZero()) {
            return ZERO;
        }
        if (ONE.equals(value)) {
            return this.mod(modulus);
        }
        return UInt32.create(this.toBigInteger().multiply(value.toBigInteger()).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 multiplyMod(int value, UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (value == 0 || this.isZero()) {
            return ZERO;
        }
        if (value == 1) {
            return this.mod(modulus);
        }
        if (value < 0) {
            throw new ArithmeticException("multiplyMod unsigned by negative");
        }
        return UInt32.create(this.toBigInteger().multiply(BigInteger.valueOf(value)).mod(modulus.toBigInteger()).intValue());
    }

    @Override
    public UInt32 multiplyMod(int value, int modulus) {
        if (modulus == 0) {
            throw new ArithmeticException("multiplyMod with zero modulus");
        }
        if (modulus < 0) {
            throw new ArithmeticException("multiplyMod unsigned with negative modulus");
        }
        if (value == 0 || this.isZero()) {
            return ZERO;
        }
        if (value == 1) {
            return this.mod(modulus);
        }
        if (value < 0) {
            throw new ArithmeticException("multiplyMod unsigned by negative");
        }
        return UInt32.create(this.toBigInteger().multiply(BigInteger.valueOf(value)).mod(BigInteger.valueOf(modulus)).intValue());
    }

    @Override
    public UInt32 divide(UInt32 value) {
        if (value.isZero()) {
            throw new ArithmeticException("divide by zero");
        }
        if (value.equals(ONE)) {
            return this;
        }
        return UInt32.create(this.toBigInteger().divide(value.toBigInteger()).intValue());
    }

    @Override
    public UInt32 divide(int value) {
        if (value == 0) {
            throw new ArithmeticException("divide by zero");
        }
        if (value < 0) {
            throw new ArithmeticException("divide unsigned by negative");
        }
        if (value == 1) {
            return this;
        }
        if (UInt32.isPowerOf2(value)) {
            return this.shiftRight(UInt32.log2(value));
        }
        return UInt32.create(this.toBigInteger().divide(BigInteger.valueOf(value)).intValue());
    }

    @Override
    public UInt32 pow(UInt32 exponent) {
        return UInt32.create(this.toBigInteger().modPow(exponent.toBigInteger(), P_2_32).intValue());
    }

    @Override
    public UInt32 pow(long exponent) {
        return UInt32.create(this.toBigInteger().modPow(BigInteger.valueOf(exponent), P_2_32).intValue());
    }

    @Override
    public UInt32 mod(UInt32 modulus) {
        if (modulus.isZero()) {
            throw new ArithmeticException("mod by zero");
        }
        return UInt32.create(Integer.remainderUnsigned(this.value.toInt(), modulus.value.toInt()));
    }

    @Override
    public UInt32 mod(int modulus) {
        if (modulus == 0) {
            throw new ArithmeticException("mod by zero");
        }
        if (modulus < 0) {
            throw new ArithmeticException("mod by negative");
        }
        return UInt32.create(Integer.remainderUnsigned(this.value.toInt(), modulus));
    }

    public UInt32 and(UInt32 value) {
        if (this.isZero() || value.isZero()) {
            return ZERO;
        }
        return UInt32.create(this.value.toInt() & value.value.toInt());
    }

    public UInt32 and(Bytes bytes) {
        if (bytes.size() > 4) {
            throw new IllegalArgumentException("and with more than 4 bytes");
        }
        if (this.isZero()) {
            return ZERO;
        }
        int value = bytes.toInt();
        if (value == 0) {
            return ZERO;
        }
        return UInt32.create(this.value.toInt() & value);
    }

    public UInt32 or(UInt32 value) {
        return UInt32.create(this.value.or(value.value));
    }

    public UInt32 or(Bytes bytes) {
        if (bytes.size() > 4) {
            throw new IllegalArgumentException("or with more than 4 bytes");
        }
        return UInt32.create(this.value.or(bytes));
    }

    public UInt32 xor(UInt32 value) {
        return UInt32.create(this.value.xor(value.value));
    }

    public UInt32 xor(int value) {
        return UInt32.create(this.value.toInt() ^ value);
    }

    public UInt32 xor(Bytes bytes) {
        if (bytes.size() > 4) {
            throw new IllegalArgumentException("xor with more than 4 bytes");
        }
        return UInt32.create(this.value.xor(bytes).toArrayUnsafe());
    }

    public UInt32 not() {
        return UInt32.create(this.value.not());
    }

    public UInt32 shiftRight(int distance) {
        if (distance == 0) {
            return this;
        }
        if (distance >= 32) {
            return ZERO;
        }
        return UInt32.create(this.value.shiftRight(distance));
    }

    public UInt32 shiftLeft(int distance) {
        if (distance == 0) {
            return this;
        }
        if (distance >= 32) {
            return ZERO;
        }
        return UInt32.create(this.value.shiftLeft(distance));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UInt32)) {
            return false;
        }
        UInt32 other = (UInt32)object;
        return this.value.equals((Object)other.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value.toInt());
    }

    @Override
    public int compareTo(UInt32 other) {
        return Long.compareUnsigned(this.value.toInt(), other.value.toInt());
    }

    public String toString() {
        return this.toHexString();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.value.toUnsignedBigInteger();
    }

    @Override
    public UInt32 toUInt32() {
        return this;
    }

    @Override
    public Bytes toBytes() {
        return this.value;
    }

    @Override
    public Bytes toMinimalBytes() {
        return this.value.slice(this.value.numberOfLeadingZeroBytes());
    }

    @Override
    public int numberOfLeadingZeros() {
        return this.value.numberOfLeadingZeros();
    }

    @Override
    public int bitLength() {
        return 32 - this.value.numberOfLeadingZeros();
    }

    private static boolean isPowerOf2(long n) {
        assert (n > 0L);
        return (n & n - 1L) == 0L;
    }

    private static int log2(int v) {
        assert (v > 0);
        return 63 - Long.numberOfLeadingZeros(v);
    }

    static {
        UInt32.CONSTANTS[0] = new UInt32(new byte[4]);
        for (int i = 1; i <= 255; ++i) {
            UInt32.CONSTANTS[i] = new UInt32(new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 0 & 0xFF)});
        }
        MIN_VALUE = UInt32.valueOf(0);
        MAX_VALUE = UInt32.create(new byte[]{-1, -1, -1, -1});
        ZERO = UInt32.valueOf(0);
        ONE = UInt32.valueOf(1);
        P_2_32 = BigInteger.valueOf(2L).pow(32);
    }
}

