/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.tuweni.bytes.ArrayWrappingBytes32;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.BytesValues;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.ConstantBytes32Value;
import org.apache.tuweni.bytes.DelegatingBytes32;
import org.apache.tuweni.bytes.GuardedByteArrayBytes32;
import org.apache.tuweni.bytes.MutableBytes32;

public interface Bytes32
extends Bytes {
    public static final int SIZE = 32;
    public static final Bytes32 ZERO = Bytes32.repeat((byte)0);

    public static Bytes32 repeat(byte b) {
        return new ConstantBytes32Value(b);
    }

    public static Bytes32 wrap(byte[] bytes) {
        Checks.checkNotNull(bytes);
        Checks.checkArgument(bytes.length == 32, "Expected %s bytes but got %s", 32, bytes.length);
        return Bytes32.wrap(bytes, 0);
    }

    public static Bytes32 wrap(byte[] bytes, int offset) {
        Checks.checkNotNull(bytes);
        return new ArrayWrappingBytes32(bytes, offset);
    }

    public static Bytes32 secure(byte[] bytes) {
        Checks.checkNotNull(bytes);
        Checks.checkArgument(bytes.length == 32, "Expected %s bytes but got %s", 32, bytes.length);
        return Bytes32.secure(bytes, 0);
    }

    public static Bytes32 secure(byte[] bytes, int offset) {
        Checks.checkNotNull(bytes);
        return new GuardedByteArrayBytes32(bytes, offset);
    }

    public static Bytes32 wrap(Bytes value) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Checks.checkArgument(value.size() == 32, "Expected %s bytes but got %s", 32, value.size());
        return new DelegatingBytes32(value);
    }

    public static Bytes32 wrap(Bytes value, int offset) {
        Checks.checkNotNull(value);
        Bytes slice = value.slice(offset, 32);
        if (slice instanceof Bytes32) {
            return (Bytes32)slice;
        }
        return new DelegatingBytes32(slice);
    }

    public static Bytes32 leftPad(Bytes value, byte fill) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Checks.checkArgument(value.size() <= 32, "Expected at most %s bytes but got %s", 32, value.size());
        MutableBytes32 result = MutableBytes32.create();
        result.fill(fill);
        value.copyTo(result, 32 - value.size());
        return result;
    }

    public static Bytes32 leftPad(Bytes value) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Checks.checkArgument(value.size() <= 32, "Expected at most %s bytes but got %s", 32, value.size());
        MutableBytes32 result = MutableBytes32.create();
        value.copyTo(result, 32 - value.size());
        return result;
    }

    public static Bytes32 rightPad(Bytes value) {
        Checks.checkNotNull(value);
        if (value instanceof Bytes32) {
            return (Bytes32)value;
        }
        Checks.checkArgument(value.size() <= 32, "Expected at most %s bytes but got %s", 32, value.size());
        MutableBytes32 result = MutableBytes32.create();
        value.copyTo(result, 0);
        return result;
    }

    public static Bytes32 fromHexStringLenient(CharSequence str) {
        Checks.checkNotNull(str);
        return Bytes32.wrap(BytesValues.fromRawHexString(str, 32, true));
    }

    public static Bytes32 fromHexString(CharSequence str) {
        Checks.checkNotNull(str);
        return Bytes32.wrap(BytesValues.fromRawHexString(str, 32, false));
    }

    public static Bytes32 random() {
        return Bytes32.random(new SecureRandom());
    }

    public static Bytes32 random(Random generator) {
        byte[] array = new byte[32];
        generator.nextBytes(array);
        return Bytes32.wrap(array);
    }

    public static Bytes32 fromHexStringStrict(CharSequence str) {
        Checks.checkNotNull(str);
        return Bytes32.wrap(BytesValues.fromRawHexString(str, -1, false));
    }

    @Override
    default public int size() {
        return 32;
    }

    default public Bytes32 and(Bytes32 other) {
        return this.and(other, MutableBytes32.create());
    }

    default public Bytes32 or(Bytes32 other) {
        return this.or(other, MutableBytes32.create());
    }

    default public Bytes32 xor(Bytes32 other) {
        return this.xor(other, MutableBytes32.create());
    }

    @Override
    default public Bytes32 not() {
        return this.not(MutableBytes32.create());
    }

    @Override
    default public Bytes32 shiftRight(int distance) {
        return this.shiftRight(distance, MutableBytes32.create());
    }

    @Override
    default public Bytes32 shiftLeft(int distance) {
        return this.shiftLeft(distance, MutableBytes32.create());
    }

    @Override
    public Bytes32 copy();

    @Override
    public MutableBytes32 mutableCopy();
}

