/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableBytes;

class ByteBufWrappingBytes
extends AbstractBytes {
    protected final ByteBuf byteBuf;

    ByteBufWrappingBytes(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    ByteBufWrappingBytes(ByteBuf byteBuf, int offset, int length) {
        Checks.checkArgument(length >= 0, "Invalid negative length");
        int bufferLength = byteBuf.capacity();
        Checks.checkElementIndex(offset, bufferLength + 1);
        Checks.checkArgument(offset + length <= bufferLength, "Provided length %s is too big: the buffer has size %s and has only %s bytes from %s", length, bufferLength, bufferLength - offset, offset);
        this.byteBuf = offset == 0 && length == bufferLength ? byteBuf : byteBuf.slice(offset, length);
    }

    @Override
    public int size() {
        return this.byteBuf.capacity();
    }

    @Override
    public byte get(int i) {
        return this.byteBuf.getByte(i);
    }

    @Override
    public int getInt(int i) {
        return this.byteBuf.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.byteBuf.getLong(i);
    }

    @Override
    public Bytes slice(int i, int length) {
        int size = this.byteBuf.capacity();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Checks.checkElementIndex(i, size);
        Checks.checkArgument(i + length <= size, "Provided length %s is too big: the value has size %s and has only %s bytes from %s", length, size, size - i, i);
        return new ByteBufWrappingBytes(this.byteBuf.slice(i, length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBuffer(Buffer.buffer((ByteBuf)this.byteBuf));
    }

    @Override
    public byte[] toArray() {
        int size = this.byteBuf.capacity();
        byte[] array = new byte[size];
        this.byteBuf.getBytes(0, array);
        return array;
    }
}

