/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.DefaultCompletableAsyncCompletion;

final class DefaultCompletableAsyncResult<T>
implements CompletableAsyncResult<T> {
    private final CompletableFuture<T> future;

    DefaultCompletableAsyncResult() {
        this(new CompletableFuture());
    }

    DefaultCompletableAsyncResult(CompletableFuture<T> future) {
        this.future = future;
    }

    @Override
    public boolean complete(@Nullable T value) {
        return this.future.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.future.completeExceptionally(ex);
    }

    @Override
    public boolean cancel() {
        return this.future.cancel(false);
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.future.isCompletedExceptionally();
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    @Nullable
    public T get() throws CompletionException, InterruptedException {
        try {
            return this.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new RuntimeException("Default timeout triggered for blocking call to AsyncResult::get()", ex);
        }
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) throws CompletionException, TimeoutException, InterruptedException {
        Objects.requireNonNull(unit);
        try {
            return this.future.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw new CompletionException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public <U> AsyncResult<U> then(Function<? super T, ? extends AsyncResult<U>> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    ((AsyncResult)fn.apply(t)).whenComplete((u, ex3) -> {
                        if (ex3 == null) {
                            asyncResult.complete(u);
                        } else {
                            asyncResult.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public <U> AsyncResult<U> thenSchedule(Vertx vertx, Function<? super T, ? extends AsyncResult<U>> fn) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.runOnContext(ev -> {
                        try {
                            ((AsyncResult)fn.apply(t)).whenComplete((u, ex4) -> {
                                if (ex4 == null) {
                                    asyncResult.complete(u);
                                } else {
                                    asyncResult.completeExceptionally((Throwable)ex4);
                                }
                            });
                        }
                        catch (Throwable ex3) {
                            asyncResult.completeExceptionally(ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public AsyncCompletion thenCompose(Function<? super T, ? extends AsyncCompletion> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    ((AsyncCompletion)fn.apply(t)).whenComplete((? super Throwable ex3) -> {
                        if (ex3 == null) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion thenRun(Runnable action) {
        Objects.requireNonNull(action);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.thenRun(action));
    }

    @Override
    public AsyncCompletion thenScheduleRun(Vertx vertx, Runnable runnable) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(runnable);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.runOnContext(ev -> {
                        try {
                            runnable.run();
                        }
                        catch (Throwable ex3) {
                            completion.completeExceptionally(ex3);
                            return;
                        }
                        completion.complete();
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion thenScheduleBlockingRun(Vertx vertx, Runnable runnable) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(runnable);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.executeBlocking(vertxFuture -> {
                        runnable.run();
                        vertxFuture.complete(null);
                    }, false, res -> {
                        if (res.succeeded()) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally(res.cause());
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public AsyncCompletion thenScheduleBlockingRun(WorkerExecutor executor, Runnable runnable) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(runnable);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    executor.executeBlocking(vertxFuture -> {
                        runnable.run();
                        vertxFuture.complete(null);
                    }, false, res -> {
                        if (res.succeeded()) {
                            completion.complete();
                        } else {
                            completion.completeExceptionally(res.cause());
                        }
                    });
                }
                catch (Throwable ex2) {
                    completion.completeExceptionally(ex2);
                }
            } else {
                completion.completeExceptionally((Throwable)ex1);
            }
        });
        return completion;
    }

    @Override
    public <U> AsyncResult<U> thenApply(Function<? super T, ? extends U> fn) {
        Objects.requireNonNull(fn);
        return new DefaultCompletableAsyncResult<T>(this.future.thenApply(fn));
    }

    @Override
    public <U> AsyncResult<U> thenScheduleApply(Vertx vertx, Function<? super T, ? extends U> fn) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.runOnContext(ev -> {
                        try {
                            asyncResult.complete(fn.apply(t));
                        }
                        catch (Throwable ex3) {
                            asyncResult.completeExceptionally(ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public <U> AsyncResult<U> thenScheduleBlockingApply(Vertx vertx, Function<? super T, ? extends U> fn) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    vertx.executeBlocking(vertxFuture -> vertxFuture.complete(fn.apply(t)), false, res -> {
                        if (res.succeeded()) {
                            asyncResult.complete(res.result());
                        } else {
                            asyncResult.completeExceptionally(res.cause());
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public <U> AsyncResult<U> thenScheduleBlockingApply(WorkerExecutor executor, Function<? super T, ? extends U> fn) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    executor.executeBlocking(vertxFuture -> vertxFuture.complete(fn.apply(t)), false, res -> {
                        if (res.succeeded()) {
                            asyncResult.complete(res.result());
                        } else {
                            asyncResult.completeExceptionally(res.cause());
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public AsyncCompletion thenAccept(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.thenAccept((Consumer)consumer));
    }

    @Override
    public <U> AsyncCompletion thenAcceptBoth(AsyncResult<? extends U> other, BiConsumer<? super T, ? super U> consumer) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.thenAccept(t -> other.thenAccept(u -> consumer.accept(t, u))));
    }

    @Override
    public <U, V> AsyncResult<V> thenCombine(AsyncResult<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(fn);
        CompletableAsyncResult asyncResult = AsyncResult.incomplete();
        this.future.whenComplete((T t, U ex1) -> {
            if (ex1 == null) {
                try {
                    other.whenComplete((u, ex3) -> {
                        if (ex3 == null) {
                            asyncResult.complete(fn.apply(t, u));
                        } else {
                            asyncResult.completeExceptionally((Throwable)ex3);
                        }
                    });
                }
                catch (Throwable ex2) {
                    asyncResult.completeExceptionally(ex2);
                }
            } else {
                asyncResult.completeExceptionally((Throwable)ex1);
            }
        });
        return asyncResult;
    }

    @Override
    public AsyncResult<T> exceptionally(Function<Throwable, ? extends T> fn) {
        Objects.requireNonNull(fn);
        return new DefaultCompletableAsyncResult<T>(this.future.exceptionally(fn));
    }

    @Override
    public AsyncResult<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        Objects.requireNonNull(action);
        return new DefaultCompletableAsyncResult<T>(this.future.whenComplete(action));
    }

    @Override
    public <U> AsyncResult<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        Objects.requireNonNull(fn);
        return new DefaultCompletableAsyncResult<T>(this.future.handle(fn));
    }

    @Override
    public AsyncCompletion accept(BiConsumer<? super T, Throwable> consumer) {
        Objects.requireNonNull(consumer);
        return new DefaultCompletableAsyncCompletion((CompletableFuture<Void>)this.future.handle((T t, U ex) -> {
            consumer.accept((Object)t, (Throwable)ex);
            return null;
        }));
    }
}

