/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.tls;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.net.tls.FingerprintRepository;
import org.apache.tuweni.net.tls.TLS;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

final class ClientFingerprintTrustManager
extends X509ExtendedTrustManager {
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = new X509Certificate[0];
    private final FingerprintRepository repository;
    private final boolean acceptNewFingerprints;
    private final boolean updateFingerprints;

    static ClientFingerprintTrustManager record(FingerprintRepository repository) {
        return new ClientFingerprintTrustManager(repository, true, true);
    }

    static ClientFingerprintTrustManager tofa(FingerprintRepository repository) {
        return new ClientFingerprintTrustManager(repository, true, false);
    }

    static ClientFingerprintTrustManager allowlist(FingerprintRepository repository) {
        return new ClientFingerprintTrustManager(repository, false, false);
    }

    private ClientFingerprintTrustManager(FingerprintRepository repository, boolean acceptNewFingerprints, boolean updateFingerprints) {
        this.repository = repository;
        this.acceptNewFingerprints = acceptNewFingerprints;
        this.updateFingerprints = updateFingerprints;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        X509Certificate cert = chain[0];
        X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
        RDN cn = x500name.getRDNs(BCStyle.CN)[0];
        String hostname = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        this.checkTrusted(chain, hostname);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        X509Certificate cert = chain[0];
        X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
        RDN cn = x500name.getRDNs(BCStyle.CN)[0];
        String hostname = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        this.checkTrusted(chain, hostname);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        throw new UnsupportedOperationException();
    }

    private void checkTrusted(X509Certificate[] chain, String host) throws CertificateException {
        X509Certificate cert = chain[0];
        Bytes fingerprint = Bytes.wrap((byte[])TLS.certificateFingerprint(cert));
        if (this.repository.contains(host, fingerprint)) {
            return;
        }
        if (this.repository.contains(host)) {
            if (!this.updateFingerprints) {
                throw new CertificateException(String.format("Client identification has changed!! Certificate for %s (%s) has fingerprint %s", host, cert.getSubjectDN(), fingerprint.toHexString().substring(2).toLowerCase(Locale.ENGLISH)));
            }
        } else if (!this.acceptNewFingerprints) {
            throw new CertificateException(String.format("Certificate for %s (%s) has unknown fingerprint %s", host, cert.getSubjectDN(), fingerprint.toHexString().substring(2).toLowerCase(Locale.ENGLISH)));
        }
        this.repository.addFingerprint(host, fingerprint);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_X509_CERTIFICATES;
    }
}

