/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ssz;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.ssz.InvalidSSZTypeException;
import org.apache.tuweni.ssz.SSZReadable;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt384;

public interface SSZReader {
    default public Bytes readBytes() {
        return this.readBytes(Integer.MAX_VALUE);
    }

    public Bytes readBytes(int var1);

    default public Bytes readFixedBytes(int byteLength) {
        return this.readFixedBytes(byteLength, Integer.MAX_VALUE);
    }

    public Bytes readFixedBytes(int var1, int var2);

    default public byte[] readByteArray() {
        return this.readByteArray(Integer.MAX_VALUE);
    }

    default public byte[] readByteArray(int limit) {
        return this.readBytes(limit).toArrayUnsafe();
    }

    default public byte[] readFixedByteArray(int byteLength, int limit) {
        return this.readFixedBytes(byteLength, limit).toArrayUnsafe();
    }

    default public String readString() {
        return new String(this.readByteArray(), StandardCharsets.UTF_8);
    }

    default public String readString(int limit) {
        return new String(this.readByteArray(limit), StandardCharsets.UTF_8);
    }

    public int readInt(int var1);

    public long readLong(int var1);

    public BigInteger readBigInteger(int var1);

    default public int readInt8() {
        return this.readInt(8);
    }

    default public int readInt16() {
        return this.readInt(16);
    }

    default public int readInt32() {
        return this.readInt(32);
    }

    default public long readInt64() {
        return this.readLong(64);
    }

    default public int readUInt(int bitLength) {
        return this.readInt(bitLength);
    }

    default public long readULong(int bitLength) {
        return this.readLong(bitLength);
    }

    public BigInteger readUnsignedBigInteger(int var1);

    default public int readUInt8() {
        return this.readUInt(8);
    }

    default public int readUInt16() {
        return this.readUInt(16);
    }

    default public long readUInt32() {
        return this.readULong(32);
    }

    default public long readUInt64() {
        return this.readULong(64);
    }

    public UInt256 readUInt256();

    public UInt384 readUInt384();

    default public boolean readBoolean() {
        int value = this.readInt(8);
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        throw new InvalidSSZTypeException("decoded value is not a boolean");
    }

    public Bytes readAddress();

    public Bytes readHash(int var1);

    default public List<Bytes> readBytesList() {
        return this.readBytesList(Integer.MAX_VALUE);
    }

    default public List<Bytes> readVector(long listSize) {
        return this.readVector(listSize, Integer.MAX_VALUE);
    }

    public List<Bytes> readFixedBytesVector(int var1, int var2, int var3);

    default public List<Bytes> readFixedBytesVector(int listSize, int byteLength) {
        return this.readFixedBytesVector(listSize, byteLength, Integer.MAX_VALUE);
    }

    public List<Bytes> readFixedBytesList(int var1, int var2);

    default public List<Bytes> readFixedBytesList(int byteLength) {
        return this.readFixedBytesList(byteLength, Integer.MAX_VALUE);
    }

    public List<Bytes> readBytesList(int var1);

    public List<Bytes> readVector(long var1, int var3);

    default public List<byte[]> readByteArrayList() {
        return this.readByteArrayList(Integer.MAX_VALUE);
    }

    default public List<byte[]> readByteArrayList(int limit) {
        return this.readBytesList(limit).stream().map(Bytes::toArrayUnsafe).collect(Collectors.toList());
    }

    default public List<String> readStringList() {
        return this.readStringList(Integer.MAX_VALUE);
    }

    public List<String> readStringList(int var1);

    public List<Integer> readIntList(int var1);

    public List<Long> readLongIntList(int var1);

    public List<BigInteger> readBigIntegerList(int var1);

    default public List<Integer> readInt8List() {
        return this.readIntList(8);
    }

    default public List<Integer> readInt16List() {
        return this.readIntList(16);
    }

    default public List<Integer> readInt32List() {
        return this.readIntList(32);
    }

    default public List<Long> readInt64List() {
        return this.readLongIntList(64);
    }

    default public List<Integer> readUIntList(int bitLength) {
        return this.readIntList(bitLength);
    }

    default public List<Long> readULongIntList(int bitLength) {
        return this.readLongIntList(bitLength);
    }

    public List<BigInteger> readUnsignedBigIntegerList(int var1);

    default public List<Integer> readUInt8List() {
        return this.readUIntList(8);
    }

    default public List<Integer> readUInt16List() {
        return this.readUIntList(16);
    }

    default public List<Long> readUInt32List() {
        return this.readULongIntList(32);
    }

    default public List<Long> readUInt64List() {
        return this.readULongIntList(64);
    }

    public List<UInt256> readUInt256List();

    public List<UInt384> readUInt384List();

    public List<Bytes> readAddressList();

    public List<Bytes> readHashList(int var1);

    public List<Boolean> readBooleanList();

    public boolean isComplete();

    public void readAsContainer(SSZReadable ... var1);

    public <T extends SSZReadable> List<T> readFixedTypedList(int var1, Supplier<T> var2);

    public <T extends SSZReadable> List<T> readTypedVector(int var1, int var2, Supplier<T> var3);

    public Bytes consumeRemainingBytes(int var1);

    public <T extends SSZReadable> List<T> readVariableSizeTypeList(Supplier<T> var1);
}

