/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ssz;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.tuweni.ssz.SSZReadable;
import org.apache.tuweni.ssz.SSZReader;
import org.apache.tuweni.ssz.SSZWritable;
import org.apache.tuweni.ssz.SSZWriter;

public class SSZVariableSizeTypeList<T extends SSZReadable & SSZWritable>
implements SSZReadable,
SSZWritable {
    private final Supplier<T> supplier;
    private final List<T> elements = new ArrayList<T>();

    public SSZVariableSizeTypeList(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public void populateFromReader(SSZReader reader) {
        this.elements.addAll(reader.readVariableSizeTypeList(this.supplier));
    }

    @Override
    public void writeTo(SSZWriter writer) {
        writer.writeTypedList(this.elements);
    }

    public List<T> getElements() {
        return this.elements;
    }
}

