/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ssz;

import java.math.BigInteger;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.ssz.SSZ;
import org.apache.tuweni.ssz.SSZWritable;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt384;

public interface SSZWriter {
    public void writeSSZ(Bytes var1);

    default public void writeSSZ(byte[] value) {
        this.writeSSZ(Bytes.wrap((byte[])value));
    }

    default public void writeBytes(Bytes value) {
        SSZ.encodeBytesTo(value, this::writeSSZ);
    }

    default public void writeBytes(byte[] value) {
        SSZ.encodeByteArrayTo(value, this::writeSSZ);
    }

    default public void writeFixedBytes(Bytes value) {
        SSZ.encodeFixedBytesTo(value, this::writeSSZ);
    }

    default public void writeString(String str) {
        SSZ.encodeStringTo(str, this::writeSSZ);
    }

    default public void writeInt(int value, int bitLength) {
        this.writeSSZ(SSZ.encodeLongToByteArray(value, bitLength));
    }

    default public void writeLong(long value, int bitLength) {
        this.writeSSZ(SSZ.encodeLongToByteArray(value, bitLength));
    }

    default public void writeBigInteger(BigInteger value, int bitLength) {
        this.writeSSZ(SSZ.encodeBigIntegerToByteArray(value, bitLength));
    }

    default public void writeInt8(int value) {
        this.writeInt(value, 8);
    }

    default public void writeInt16(int value) {
        this.writeInt(value, 16);
    }

    default public void writeInt32(int value) {
        this.writeInt(value, 32);
    }

    default public void writeInt64(long value) {
        this.writeLong(value, 64);
    }

    default public void writeUInt(int value, int bitLength) {
        this.writeSSZ(SSZ.encodeULongToByteArray(value, bitLength));
    }

    default public void writeULong(long value, int bitLength) {
        this.writeSSZ(SSZ.encodeULongToByteArray(value, bitLength));
    }

    default public void writeUBigInteger(BigInteger value, int bitLength) {
        this.writeSSZ(SSZ.encodeUBigIntegerToByteArray(value, bitLength));
    }

    default public void writeUInt8(int value) {
        this.writeUInt(value, 8);
    }

    default public void writeUInt16(int value) {
        this.writeUInt(value, 16);
    }

    default public void writeUInt32(long value) {
        this.writeULong(value, 32);
    }

    default public void writeUInt64(long value) {
        this.writeULong(value, 64);
    }

    default public void writeUInt256(UInt256 value) {
        this.writeSSZ(SSZ.encodeUInt256(value));
    }

    default public void writeUInt384(UInt384 value) {
        this.writeSSZ(SSZ.encodeUInt384(value));
    }

    default public void writeBoolean(boolean value) {
        this.writeSSZ(SSZ.encodeBoolean(value));
    }

    default public void writeAddress(Bytes address) {
        this.writeSSZ(SSZ.encodeAddress(address));
    }

    default public void writeHash(Bytes hash) {
        this.writeSSZ(SSZ.encodeHash(hash));
    }

    default public void writeBytesList(Bytes ... elements) {
        SSZ.encodeBytesListTo(elements, this::writeSSZ);
    }

    default public void writeBytesList(List<? extends Bytes> elements) {
        SSZ.encodeBytesListTo(elements, this::writeSSZ);
    }

    default public void writeVector(List<? extends Bytes> elements) {
        SSZ.encodeBytesVectorTo(elements, this::writeSSZ);
    }

    default public void writeFixedBytesList(List<? extends Bytes> elements) {
        SSZ.encodeFixedBytesListTo(elements, this::writeSSZ);
    }

    default public void writeFixedBytesVector(List<? extends Bytes> elements) {
        SSZ.encodeFixedBytesVectorTo(elements, this::writeSSZ);
    }

    default public void writeStringList(String ... elements) {
        SSZ.encodeStringListTo(elements, this::writeSSZ);
    }

    default public void writeStringList(List<String> elements) {
        SSZ.encodeStringListTo(elements, this::writeSSZ);
    }

    default public void writeIntList(int bitLength, int ... elements) {
        SSZ.encodeIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeIntList(int bitLength, List<Integer> elements) {
        SSZ.encodeIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeLongIntList(int bitLength, long ... elements) {
        SSZ.encodeLongIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeLongIntList(int bitLength, List<Long> elements) {
        SSZ.encodeLongIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeBigIntegerList(int bitLength, BigInteger ... elements) {
        SSZ.encodeBigIntegerListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeBigIntegerList(int bitLength, List<BigInteger> elements) {
        SSZ.encodeBigIntegerListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeInt8List(int ... elements) {
        this.writeIntList(8, elements);
    }

    default public void writeInt8List(List<Integer> elements) {
        this.writeIntList(8, elements);
    }

    default public void writeInt16List(int ... elements) {
        this.writeIntList(16, elements);
    }

    default public void writeInt16List(List<Integer> elements) {
        this.writeIntList(16, elements);
    }

    default public void writeInt32List(int ... elements) {
        this.writeIntList(32, elements);
    }

    default public void writeInt32List(List<Integer> elements) {
        this.writeIntList(32, elements);
    }

    default public void writeInt64List(long ... elements) {
        this.writeLongIntList(64, elements);
    }

    default public void writeInt64List(List<Long> elements) {
        this.writeLongIntList(64, elements);
    }

    default public void writeUIntList(int bitLength, int ... elements) {
        SSZ.encodeUIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeUIntList(int bitLength, List<Integer> elements) {
        SSZ.encodeUIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeULongIntList(int bitLength, long ... elements) {
        SSZ.encodeULongIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeULongIntList(int bitLength, List<Long> elements) {
        SSZ.encodeULongIntListTo(bitLength, elements, this::writeSSZ);
    }

    default public void writeUInt8List(int ... elements) {
        this.writeUIntList(8, elements);
    }

    default public void writeUInt8List(List<Integer> elements) {
        this.writeUIntList(8, elements);
    }

    default public void writeUInt16List(int ... elements) {
        this.writeUIntList(16, elements);
    }

    default public void writeUInt16List(List<Integer> elements) {
        this.writeUIntList(16, elements);
    }

    default public void writeUInt32List(long ... elements) {
        this.writeULongIntList(32, elements);
    }

    default public void writeUInt32List(List<Long> elements) {
        this.writeULongIntList(32, elements);
    }

    default public void writeUInt64List(long ... elements) {
        this.writeULongIntList(64, elements);
    }

    default public void writeUInt64List(List<Long> elements) {
        this.writeULongIntList(64, elements);
    }

    default public void writeUInt256List(UInt256 ... elements) {
        SSZ.encodeUInt256ListTo(elements, this::writeSSZ);
    }

    default public void writeUInt256List(List<UInt256> elements) {
        SSZ.encodeUInt256ListTo(elements, this::writeSSZ);
    }

    default public void writeUInt384List(List<UInt384> elements) {
        SSZ.encodeUInt384ListTo(elements, this::writeSSZ);
    }

    default public void writeUInt384List(UInt384 ... elements) {
        SSZ.encodeUInt384ListTo(elements, this::writeSSZ);
    }

    default public void writeHashList(Bytes ... elements) {
        SSZ.encodeHashListTo(elements, this::writeSSZ);
    }

    default public void writeHashList(List<? extends Bytes> elements) {
        SSZ.encodeHashListTo(elements, this::writeSSZ);
    }

    default public void writeAddressList(Bytes ... elements) {
        SSZ.encodeAddressListTo(elements, this::writeSSZ);
    }

    default public void writeAddressList(List<? extends Bytes> elements) {
        SSZ.encodeAddressListTo(elements, this::writeSSZ);
    }

    default public void writeBooleanList(boolean ... elements) {
        SSZ.encodeBooleanListTo(elements, this::writeSSZ);
    }

    default public void writeBooleanList(List<Boolean> elements) {
        SSZ.encodeBooleanListTo(elements, this::writeSSZ);
    }

    default public void writeAsContainer(SSZWritable ... elements) {
        SSZ.encodeAsContainerTo(this::writeSSZ, elements);
    }

    default public <T extends SSZWritable> void writeTypedList(List<T> elements) {
        SSZ.encodeAsFixedTypeListTo(elements, this::writeSSZ);
    }

    default public <T extends SSZWritable> void writeTypedVector(List<T> elements) {
        SSZ.encodeAsFixedTypeVectorTo(elements, this::writeSSZ);
    }
}

