/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.event;

import io.corbel.eventbus.Event;
import io.corbel.eventbus.EventWithSpecificDomain;

public class AuthorizationEvent
extends EventWithSpecificDomain {
    private IssuerType issuerType;
    private String id;

    public AuthorizationEvent() {
    }

    public AuthorizationEvent(String domainId, IssuerType issuerType, String id) {
        super(domainId);
        this.issuerType = issuerType;
        this.id = id;
    }

    public IssuerType getIssuerType() {
        return this.issuerType;
    }

    public String getId() {
        return this.id;
    }

    public void setIssuerType(IssuerType issuerType) {
        this.issuerType = issuerType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.issuerType == null ? 0 : this.issuerType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationEvent other = (AuthorizationEvent)((Object)obj);
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.issuerType == null ? other.issuerType != null : !this.issuerType.equals((Object)other.issuerType));
    }

    public static Event userAuthenticationEvent(String domainId, String id) {
        return new AuthorizationEvent(domainId, IssuerType.USER, id);
    }

    public static Event clientAuthenticationEvent(String domainId, String id) {
        return new AuthorizationEvent(domainId, IssuerType.CLIENT, id);
    }

    public static enum IssuerType {
        USER,
        CLIENT;

    }
}

