/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo;

import com.mongodb.DBObject;
import io.corbel.lib.mongo.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;

public class IdGeneratorMongoEventListener<E>
extends AbstractMongoEventListener<E> {
    private static final Logger LOG = LoggerFactory.getLogger(IdGeneratorMongoEventListener.class);
    private static final String _ID = "_id";
    private final IdGenerator<E> generator;
    private final Class<?> domainClass;

    public IdGeneratorMongoEventListener(IdGenerator<E> generator, Class<E> domainClass) {
        this.generator = generator;
        this.domainClass = domainClass;
    }

    public void onBeforeSave(BeforeSaveEvent<E> event) {
        DBObject dbo;
        Object source = event.getSource();
        if (this.matchDomainClass(source) && (!(dbo = event.getDBObject()).containsField(_ID) || dbo.get(_ID) == null)) {
            String generateId = this.generator.generateId(source);
            LOG.debug("Generated _id for {}: {}", source, (Object)generateId);
            dbo.put(_ID, (Object)generateId);
        }
        super.onBeforeSave(event);
    }

    private boolean matchDomainClass(E source) {
        return this.domainClass.isAssignableFrom(source.getClass());
    }
}

