/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import io.corbel.lib.mongo.SafeKeys;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bson.types.ObjectId;
import org.springframework.core.convert.converter.Converter;

public class JsonObjectMongoReadConverter
implements Converter<DBObject, JsonObject> {
    private final Gson gson;

    public JsonObjectMongoReadConverter(Gson gson) {
        this.gson = gson;
    }

    public JsonObject convert(DBObject source) {
        if (source == null) {
            return null;
        }
        return (JsonObject)this.gson.toJsonTree(this.rewriteMapFields(source.toMap()));
    }

    private Map<String, Object> rewriteMapFields(Map<String, Object> map) {
        final HashMap<String, Object> returnMap = new HashMap<String, Object>();
        map.forEach(new BiConsumer<String, Object>(){

            @Override
            public void accept(String key, Object value) {
                String originalKey = SafeKeys.getOriginalKey(key);
                if (value instanceof Date) {
                    returnMap.put(originalKey, ((Date)value).getTime());
                } else if (value instanceof Map) {
                    returnMap.put(originalKey, JsonObjectMongoReadConverter.this.rewriteMapFields((Map)value));
                } else if (value instanceof ObjectId) {
                    returnMap.put(originalKey, value.toString());
                } else if (value instanceof BasicDBList) {
                    returnMap.put(originalKey, JsonObjectMongoReadConverter.this.rewriteArrayFields((List)value));
                } else {
                    returnMap.put(originalKey, value);
                }
            }
        });
        return returnMap;
    }

    private List rewriteArrayFields(List list) {
        ArrayList returnList = new ArrayList();
        list.stream().forEach(item -> {
            if (item instanceof Map) {
                returnList.add(this.rewriteMapFields((Map)item));
            } else if (item instanceof BasicDBList) {
                returnList.add(this.rewriteArrayFields((List)item));
            } else {
                returnList.add(item);
            }
        });
        return returnList;
    }
}

